"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSortingOptions = void 0;
var _sort = require("../../common/data/sort");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const sortOptions = {
  ..._sort.commonSortingOptions,
  name(direction = 'asc') {
    return [{
      'original_dashboard.title.keyword': direction
    }];
  },
  installedDashboardId(direction = 'asc') {
    const field = 'elastic_dashboard.id';
    return (0, _sort.getFieldExistenceSort)(field)(direction);
  },
  originalDashboardLastUpdate(direction = 'desc') {
    return [{
      'original_dashboard.last_updated': direction
    }];
  },
  splunkApp(direction = 'asc') {
    return [{
      'original_dashboard.splunk_properties.app': direction
    }];
  }
};
const DEFAULT_SORT = [...sortOptions.translationResult('desc'), ...sortOptions.installedDashboardId('desc'), ...sortOptions.name('asc')];
const sortOptionsMap = {
  'original_dashboard.title': sortOptions.name,
  'original_dashboard.last_updated': direction => [...sortOptions.originalDashboardLastUpdate(direction), ...sortOptions.translationResult(direction), ...sortOptions.installedDashboardId(direction)],
  'original_dashboard.splunk_properties.app': sortOptions.splunkApp,
  updated: sortOptions.updated,
  translation_result: direction => [...sortOptions.translationResult(direction)]
};
const getSortingOptions = sort => {
  var _sortOptionsMap$sort$, _sortOptionsMap$sort$2;
  if (!(sort !== null && sort !== void 0 && sort.sortField)) {
    return DEFAULT_SORT;
  }
  return (_sortOptionsMap$sort$ = (_sortOptionsMap$sort$2 = sortOptionsMap[sort.sortField]) === null || _sortOptionsMap$sort$2 === void 0 ? void 0 : _sortOptionsMap$sort$2.call(sortOptionsMap, sort.sortDirection)) !== null && _sortOptionsMap$sort$ !== void 0 ? _sortOptionsMap$sort$ : DEFAULT_SORT;
};
exports.getSortingOptions = getSortingOptions;