"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerSiemDashboardMigrationsGetDashboardsRoute = void 0;
var _zodHelpers = require("@kbn/zod-helpers");
var _dashboard_migration = require("../../../../../../common/siem_migrations/model/api/dashboards/dashboard_migration.gen");
var _constants = require("../../../../../../common/siem_migrations/dashboards/constants");
var _authz = require("../../../common/api/util/authz");
var _with_license = require("../../../common/api/util/with_license");
var _with_existing_migration_id = require("../../../common/api/util/with_existing_migration_id");
var _audit = require("../../../common/api/util/audit");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerSiemDashboardMigrationsGetDashboardsRoute = (router, logger) => {
  router.versioned.get({
    path: _constants.SIEM_DASHBOARD_MIGRATION_DASHBOARDS_PATH,
    access: 'internal',
    security: {
      authz: _authz.authz
    }
  }).addVersion({
    version: '1',
    validate: {
      request: {
        params: (0, _zodHelpers.buildRouteValidationWithZod)(_dashboard_migration.GetDashboardMigrationDashboardsRequestParams),
        query: (0, _zodHelpers.buildRouteValidationWithZod)(_dashboard_migration.GetDashboardMigrationDashboardsRequestQuery)
      }
    }
  }, (0, _with_license.withLicense)((0, _with_existing_migration_id.withExistingMigration)(async (context, req, res) => {
    const {
      migration_id: migrationId
    } = req.params;
    const siemMigrationAuditLogger = new _audit.SiemMigrationAuditLogger(context.securitySolution, 'dashboards');
    try {
      const ctx = await context.resolve(['securitySolution']);
      const dashboardMigrationsClient = ctx.securitySolution.siemMigrations.getDashboardsClient();
      const {
        page,
        per_page: size
      } = req.query;
      const options = {
        filters: {
          searchTerm: req.query.search_term,
          ids: req.query.ids,
          installed: req.query.is_installed,
          fullyTranslated: req.query.is_fully_translated,
          partiallyTranslated: req.query.is_partially_translated,
          untranslatable: req.query.is_untranslatable,
          failed: req.query.is_failed
        },
        sort: {
          sortField: req.query.sort_field,
          sortDirection: req.query.sort_direction
        },
        size,
        from: page && size ? page * size : 0
      };
      const result = await dashboardMigrationsClient.data.items.get(migrationId, options);
      await siemMigrationAuditLogger.logGetMigrationItems({
        migrationId
      });
      return res.ok({
        body: result
      });
    } catch (error) {
      logger.error(error);
      await siemMigrationAuditLogger.logGetMigrationItems({
        migrationId,
        error
      });
      return res.badRequest({
        body: error.message
      });
    }
  })));
};
exports.registerSiemDashboardMigrationsGetDashboardsRoute = registerSiemDashboardMigrationsGetDashboardsRoute;