"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withExistingMigration = void 0;
var _translations = require("../../translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Checks the existence of a valid migration before proceeding with the request.
 *
 * if not found, it returns a 404 error with a message.
 * if found, it adds the migration to the context.
 *
 * */
const withExistingMigration = handler => {
  return async (context, req, res) => {
    const {
      migration_id: migrationId
    } = req.params;
    const pathParts = req.route.path.split('/');
    const ctx = await context.resolve(['securitySolution']);
    const migrationsClient = pathParts.includes('rules') ? ctx.securitySolution.siemMigrations.getRulesClient() : ctx.securitySolution.siemMigrations.getDashboardsClient();
    const storedMigration = await migrationsClient.data.migrations.get(migrationId);
    if (!storedMigration) {
      return res.notFound({
        body: (0, _translations.MIGRATION_ID_NOT_FOUND)(migrationId)
      });
    }
    return handler(context, req, res);
  };
};
exports.withExistingMigration = withExistingMigration;