"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createTracersCallbacks = void 0;
var _apm = require("@kbn/langchain/server/tracers/apm");
var _langsmith = require("@kbn/langchain/server/tracers/langsmith");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createTracersCallbacks = (langsmithOptions, logger) => {
  const {
    api_key: apiKey,
    project_name: projectName = 'default'
  } = langsmithOptions !== null && langsmithOptions !== void 0 ? langsmithOptions : {};
  const callbacks = [new _apm.APMTracer({
    projectName
  }, logger)];
  if (langsmithOptions) {
    callbacks.push(...(0, _langsmith.getLangSmithTracer)({
      apiKey,
      projectName,
      logger
    }));
  }
  return callbacks;
};
exports.createTracersCallbacks = createTracersCallbacks;