"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.riskEngineStatusRoute = void 0;
var _utils = require("@kbn/lists-plugin/server/routes/utils");
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _constants = require("../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const riskEngineStatusRoute = (router, getStartServices) => {
  router.versioned.get({
    access: 'internal',
    path: _constants.RISK_ENGINE_STATUS_URL,
    security: {
      authz: {
        requiredPrivileges: ['securitySolution', `${_constants.APP_ID}-entity-analytics`]
      }
    }
  }).addVersion({
    version: '1',
    validate: {}
  }, async (context, request, response) => {
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    const securitySolution = await context.securitySolution;
    const riskEngineClient = securitySolution.getRiskEngineDataClient();
    const spaceId = securitySolution.getSpaceId();
    const [_, {
      taskManager
    }] = await getStartServices();
    try {
      const {
        riskEngineStatus,
        taskStatus
      } = await riskEngineClient.getStatus({
        namespace: spaceId,
        taskManager
      });
      const body = {
        risk_engine_status: riskEngineStatus,
        risk_engine_task_status: taskStatus
      };
      return response.ok({
        body
      });
    } catch (e) {
      const error = (0, _securitysolutionEsUtils.transformError)(e);
      return siemResponse.error({
        statusCode: error.statusCode,
        body: {
          message: error.message,
          full_error: JSON.stringify(e)
        },
        bypassErrorFormat: true
      });
    }
  });
};
exports.riskEngineStatusRoute = riskEngineStatusRoute;