"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateUserIndexMappings = exports.PRIVILEGED_MONITOR_USERS_INDEX_MAPPING = exports.PRIVILEGED_MONITOR_IMPORT_USERS_INDEX_MAPPING = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PRIVILEGED_MONITOR_IMPORT_USERS_INDEX_MAPPING = exports.PRIVILEGED_MONITOR_IMPORT_USERS_INDEX_MAPPING = {
  user: {
    properties: {
      name: {
        type: 'keyword'
      }
    }
  }
};
const PRIVILEGED_MONITOR_USERS_INDEX_MAPPING = exports.PRIVILEGED_MONITOR_USERS_INDEX_MAPPING = {
  'event.ingested': {
    type: 'date'
  },
  '@timestamp': {
    type: 'date'
  },
  'user.name': {
    type: 'keyword'
  },
  'user.is_privileged': {
    type: 'boolean'
  },
  'labels.sources': {
    type: 'keyword'
  },
  'entity_analytics_monitoring.labels.field': {
    type: 'keyword'
  },
  'entity_analytics_monitoring.labels.source': {
    type: 'keyword'
  },
  'entity_analytics_monitoring.labels.value': {
    type: 'keyword'
  }
};
const generateUserIndexMappings = () => ({
  properties: PRIVILEGED_MONITOR_USERS_INDEX_MAPPING
});
exports.generateUserIndexMappings = generateUserIndexMappings;