"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VERSION = exports.TYPE = exports.TIMEOUT = exports.SCOPE = exports.SCHEDULE = exports.MAX_ATTEMPTS = void 0;
var _rrule = require("@kbn/rrule");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SCOPE = exports.SCOPE = ['securitySolution'];
const TYPE = exports.TYPE = 'entity_store:snapshot';
const VERSION = exports.VERSION = '1.0.0';
const TIMEOUT = exports.TIMEOUT = '1h';
const MAX_ATTEMPTS = exports.MAX_ATTEMPTS = 5;
// Run every day at 00:01 UTC
const SCHEDULE = exports.SCHEDULE = {
  rrule: {
    freq: _rrule.Frequency.DAILY,
    tzid: 'UTC',
    interval: 1,
    byhour: [0],
    byminute: [1]
  }
};