"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEntityStoreStatusRoute = void 0;
var _utils = require("@kbn/lists-plugin/server/routes/utils");
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _zodHelpers = require("@kbn/zod-helpers");
var _status = require("../../../../../common/api/entity_analytics/entity_store/status.gen");
var _constants = require("../../../../../common/constants");
var _check_and_init_asset_criticality_resources = require("../../asset_criticality/check_and_init_asset_criticality_resources");
var _check_and_init_privmon_resources = require("../../privilege_monitoring/check_and_init_privmon_resources");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getEntityStoreStatusRoute = (router, logger, config) => {
  router.versioned.get({
    access: 'public',
    path: '/api/entity_store/status',
    security: {
      authz: {
        requiredPrivileges: ['securitySolution', `${_constants.APP_ID}-entity-analytics`]
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: {
        query: (0, _zodHelpers.buildRouteValidationWithZod)(_status.GetEntityStoreStatusRequestQuery)
      }
    }
  }, async (context, request, response) => {
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    const secSol = await context.securitySolution;
    await (0, _check_and_init_asset_criticality_resources.checkAndInitAssetCriticalityResources)(context, logger);
    await (0, _check_and_init_privmon_resources.checkAndInitPrivilegeMonitoringResources)(context, logger);
    try {
      const body = await secSol.getEntityStoreDataClient().status(request.query);
      return response.ok({
        body
      });
    } catch (e) {
      const error = (0, _securitysolutionEsUtils.transformError)(e);
      logger.error(`Error initialising entity store: ${error.message}`);
      return siemResponse.error({
        statusCode: error.statusCode,
        body: error.message
      });
    }
  });
};
exports.getEntityStoreStatusRoute = getEntityStoreStatusRoute;