"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEntityFieldsDescriptions = exports.getCommonFieldDescriptions = void 0;
var _field_utils = require("./field_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getCommonFieldDescriptions = ecsField => {
  return [(0, _field_utils.oldestValue)({
    source: '_index',
    destination: 'entity.source'
  }), (0, _field_utils.newestValue)({
    source: 'asset.id'
  }), (0, _field_utils.newestValue)({
    source: 'asset.name'
  }), (0, _field_utils.newestValue)({
    source: 'asset.owner'
  }), (0, _field_utils.newestValue)({
    source: 'asset.serial_number'
  }), (0, _field_utils.newestValue)({
    source: 'asset.model'
  }), (0, _field_utils.newestValue)({
    source: 'asset.vendor'
  }), (0, _field_utils.newestValue)({
    source: 'asset.environment'
  }), (0, _field_utils.newestValue)({
    source: 'asset.criticality'
  }), (0, _field_utils.newestValue)({
    source: 'asset.business_unit'
  }), (0, _field_utils.newestValue)({
    source: `${ecsField}.risk.calculated_level`
  }), (0, _field_utils.newestValue)({
    source: `${ecsField}.risk.calculated_score`,
    mapping: {
      type: 'float'
    }
  }), (0, _field_utils.newestValue)({
    source: `${ecsField}.risk.calculated_score_norm`,
    mapping: {
      type: 'float'
    }
  })];
};
exports.getCommonFieldDescriptions = getCommonFieldDescriptions;
const getEntityFieldsDescriptions = rootField => {
  const prefix = rootField ? `${rootField}.entity` : 'entity';
  return [(0, _field_utils.newestValue)({
    source: `${prefix}.name`,
    destination: 'entity.name'
  }), (0, _field_utils.newestValue)({
    source: `${prefix}.source`,
    destination: 'entity.source'
  }), (0, _field_utils.newestValue)({
    source: `${prefix}.type`,
    destination: 'entity.type'
  }), (0, _field_utils.newestValue)({
    source: `${prefix}.sub_type`,
    destination: 'entity.sub_type'
  }), (0, _field_utils.newestValue)({
    source: `${prefix}.url`,
    destination: 'entity.url'
  }), (0, _field_utils.newestValue)({
    source: `${prefix}.attributes.Privileged`,
    destination: 'entity.attributes.Privileged',
    mapping: {
      type: 'boolean'
    },
    allowAPIUpdate: true
  }), (0, _field_utils.newestValue)({
    source: `${prefix}.attributes.Asset`,
    destination: 'entity.attributes.Asset',
    mapping: {
      type: 'boolean'
    },
    allowAPIUpdate: true
  }), (0, _field_utils.newestValue)({
    source: `${prefix}.attributes.Managed`,
    destination: 'entity.attributes.Managed',
    mapping: {
      type: 'boolean'
    },
    allowAPIUpdate: true
  }), (0, _field_utils.newestValue)({
    source: `${prefix}.attributes.Mfa_enabled`,
    destination: 'entity.attributes.Mfa_enabled',
    mapping: {
      type: 'boolean'
    },
    allowAPIUpdate: true
  }), /* Lifecycle fields should not allow update via the API */
  (0, _field_utils.newestValue)({
    source: `${prefix}.lifecycle.First_seen`,
    destination: 'entity.lifecycle.First_seen',
    mapping: {
      type: 'date'
    }
  }), (0, _field_utils.newestValue)({
    source: `${prefix}.lifecycle.Last_activity`,
    destination: 'entity.lifecycle.Last_activity',
    mapping: {
      type: 'date'
    }
  }), (0, _field_utils.newestValue)({
    source: `${prefix}.behaviors.Brute_force_victim`,
    destination: 'entity.behaviors.Brute_force_victim',
    mapping: {
      type: 'boolean'
    },
    allowAPIUpdate: true
  }), (0, _field_utils.newestValue)({
    source: `${prefix}.behaviors.New_country_login`,
    destination: 'entity.behaviors.New_country_login',
    mapping: {
      type: 'boolean'
    },
    allowAPIUpdate: true
  }), (0, _field_utils.newestValue)({
    source: `${prefix}.behaviors.Used_usb_device`,
    destination: 'entity.behaviors.Used_usb_device',
    mapping: {
      type: 'boolean'
    },
    allowAPIUpdate: true
  }), (0, _field_utils.newestValue)({
    source: `${prefix}.risk.calculated_level`,
    destination: 'entity.risk.calculated_level'
  }), (0, _field_utils.newestValue)({
    source: `${prefix}.risk.calculated_score`,
    destination: 'entity.risk.calculated_score',
    mapping: {
      type: 'float'
    }
  }), (0, _field_utils.newestValue)({
    source: `${prefix}.risk.calculated_score_norm`,
    destination: 'entity.risk.calculated_score_norm',
    mapping: {
      type: 'float'
    }
  })];
};
exports.getEntityFieldsDescriptions = getEntityFieldsDescriptions;