"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.checkAndInitAssetCriticalityResources = void 0;
var _asset_criticality_data_client = require("./asset_criticality_data_client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * As internal user we check for existence of asset criticality resources
 * and initialise it if it does not exist
 * @param context
 * @param logger
 */
const checkAndInitAssetCriticalityResources = async (context, logger) => {
  const securityContext = await context.securitySolution;
  const coreContext = await context.core;
  const esClient = coreContext.elasticsearch.client.asInternalUser;
  const assetCriticalityDataClient = new _asset_criticality_data_client.AssetCriticalityDataClient({
    esClient,
    logger,
    auditLogger: securityContext.getAuditLogger(),
    namespace: securityContext.getSpaceId()
  });
  const doesIndexExist = await assetCriticalityDataClient.doesIndexExist();
  if (!doesIndexExist) {
    logger.info('Asset criticality resources are not installed, initialising...');
    await assetCriticalityDataClient.init();
    logger.info('Asset criticality resources installed');
  }
};
exports.checkAndInitAssetCriticalityResources = checkAndInitAssetCriticalityResources;