"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.bulkCreateSuppressedNewTermsAlertsInMemory = void 0;
var _constants = require("../../../../../common/detection_engine/constants");
var _rule_schema = require("../../../../../common/api/detection_engine/model/rule_schema");
var _bulk_create_suppressed_alerts_in_memory = require("../utils/bulk_create_suppressed_alerts_in_memory");
var _partition_missing_fields_events = require("../utils/partition_missing_fields_events");
var _wrap_new_terms_alerts = require("./wrap_new_terms_alerts");
var _wrap_suppressed_new_terms_alerts = require("./wrap_suppressed_new_terms_alerts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * wraps, bulk create and suppress alerts in memory, also takes care of missing fields logic.
 * If parameter alertSuppression.missingFieldsStrategy configured not to be suppressed, regular alerts will be created for such events without suppression
 * This function is similar to x-pack/solutions/security/plugins/security_solution/server/lib/detection_engine/rule_types/utils/bulk_create_suppressed_alerts_in_memory.ts, but
 * it operates with new terms specific eventsAndTerms{@link EventsAndTerms} parameter property, instead of regular events as common utility
 */
const bulkCreateSuppressedNewTermsAlertsInMemory = async ({
  sharedParams,
  eventsAndTerms,
  toReturn,
  services,
  alertSuppression
}) => {
  var _alertSuppression$mis;
  const suppressOnMissingFields = ((_alertSuppression$mis = alertSuppression.missingFieldsStrategy) !== null && _alertSuppression$mis !== void 0 ? _alertSuppression$mis : _constants.DEFAULT_SUPPRESSION_MISSING_FIELDS_STRATEGY) === _rule_schema.AlertSuppressionMissingFieldsStrategyEnum.suppress;
  let suppressibleEvents = eventsAndTerms;
  let unsuppressibleWrappedDocs = [];
  if (!suppressOnMissingFields) {
    const partitionedEvents = (0, _partition_missing_fields_events.partitionMissingFieldsEvents)(eventsAndTerms, alertSuppression.groupBy || [], ['event', 'fields']);
    unsuppressibleWrappedDocs = (0, _wrap_new_terms_alerts.wrapNewTermsAlerts)({
      sharedParams,
      eventsAndTerms: partitionedEvents[1]
    });
    suppressibleEvents = partitionedEvents[0];
  }
  const suppressibleWrappedDocs = (0, _wrap_suppressed_new_terms_alerts.wrapSuppressedNewTermsAlerts)({
    sharedParams,
    eventsAndTerms: suppressibleEvents
  });
  return (0, _bulk_create_suppressed_alerts_in_memory.executeBulkCreateAlerts)({
    sharedParams,
    suppressibleWrappedDocs,
    unsuppressibleWrappedDocs,
    toReturn,
    services,
    alertSuppression
  });
};
exports.bulkCreateSuppressedNewTermsAlertsInMemory = bulkCreateSuppressedNewTermsAlertsInMemory;