"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.wrapSequences = void 0;
var _build_alert_group_from_sequence = require("./build_alert_group_from_sequence");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const wrapSequences = ({
  sharedParams,
  sequences,
  buildReasonMessage
}) => sequences.reduce((acc, sequence) => {
  const {
    shellAlert,
    buildingBlocks
  } = (0, _build_alert_group_from_sequence.buildAlertGroupFromSequence)({
    sharedParams,
    sequence,
    buildReasonMessage
  });
  if (shellAlert) {
    acc.push(shellAlert, ...buildingBlocks);
    return acc;
  }
  return acc;
}, []);
exports.wrapSequences = wrapSequences;