"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.legacyCreatePrepackagedRules = exports.PrepackagedRulesError = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _get_existing_prepackaged_rules = require("../../../rule_management/logic/search/get_existing_prepackaged_rules");
var _ensure_latest_rules_package_installed = require("../../logic/integrations/ensure_latest_rules_package_installed");
var _get_rules_to_install = require("../../logic/get_rules_to_install");
var _get_rules_to_update = require("../../logic/get_rules_to_update");
var _perform_timelines_installation = require("../../logic/perform_timelines_installation");
var _prebuilt_rule_assets_client = require("../../logic/rule_assets/prebuilt_rule_assets_client");
var _create_prebuilt_rules = require("../../logic/rule_objects/create_prebuilt_rules");
var _upgrade_prebuilt_rules = require("../../logic/rule_objects/upgrade_prebuilt_rules");
var _utils = require("../../logic/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class PrepackagedRulesError extends Error {
  constructor(message, statusCode) {
    super(message);
    (0, _defineProperty2.default)(this, "statusCode", void 0);
    this.statusCode = statusCode;
  }
}

/**
 * @deprecated This method is incompatible with prebuilt rules customization as
 * it upgrades prebuilt rules to their 'target' version erasing any
 * customizations. Use createPrebuiltRules instead.
 */
exports.PrepackagedRulesError = PrepackagedRulesError;
const legacyCreatePrepackagedRules = async (context, rulesClient, logger, exceptionsClient) => {
  var _context$getException, _timelinesResult$time, _timelinesResult$time2;
  const savedObjectsClient = context.core.savedObjects.client;
  const siemClient = context.getAppClient();
  const exceptionsListClient = (_context$getException = context.getExceptionListClient()) !== null && _context$getException !== void 0 ? _context$getException : exceptionsClient;
  const detectionRulesClient = context.getDetectionRulesClient();
  const ruleAssetsClient = (0, _prebuilt_rule_assets_client.createPrebuiltRuleAssetsClient)(savedObjectsClient);
  if (!siemClient || !rulesClient) {
    throw new PrepackagedRulesError('', 404);
  }

  // This will create the endpoint list if it does not exist yet
  if (exceptionsListClient != null) {
    await exceptionsListClient.createEndpointList();
  }
  const latestPrebuiltRules = await (0, _ensure_latest_rules_package_installed.ensureLatestRulesPackageInstalled)(ruleAssetsClient, context, logger);
  const installedPrebuiltRules = (0, _utils.rulesToMap)(await (0, _get_existing_prepackaged_rules.getExistingPrepackagedRules)({
    rulesClient,
    logger
  }));
  const rulesToInstall = (0, _get_rules_to_install.getRulesToInstall)(latestPrebuiltRules, installedPrebuiltRules);
  const rulesToUpdate = (0, _get_rules_to_update.getRulesToUpdate)(latestPrebuiltRules, installedPrebuiltRules);
  const ruleCreationResult = await (0, _create_prebuilt_rules.createPrebuiltRules)(detectionRulesClient, rulesToInstall, logger);
  if (ruleCreationResult.errors.length > 0) {
    throw new AggregateError(ruleCreationResult.errors, 'Error installing new prebuilt rules');
  }
  const {
    result: timelinesResult
  } = await (0, _perform_timelines_installation.performTimelinesInstallation)(context);
  await (0, _upgrade_prebuilt_rules.upgradePrebuiltRules)(detectionRulesClient, rulesToUpdate, logger);
  return {
    rules_installed: rulesToInstall.length,
    rules_updated: rulesToUpdate.length,
    timelines_installed: (_timelinesResult$time = timelinesResult === null || timelinesResult === void 0 ? void 0 : timelinesResult.timelines_installed) !== null && _timelinesResult$time !== void 0 ? _timelinesResult$time : 0,
    timelines_updated: (_timelinesResult$time2 = timelinesResult === null || timelinesResult === void 0 ? void 0 : timelinesResult.timelines_updated) !== null && _timelinesResult$time2 !== void 0 ? _timelinesResult$time2 : 0
  };
};
exports.legacyCreatePrepackagedRules = legacyCreatePrepackagedRules;