"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerAssetInventoryRoutes = void 0;
var _delete = require("./delete");
var _enablement = require("./enablement");
var _status = require("./status");
var _install_data_view = require("./install_data_view");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerAssetInventoryRoutes = ({
  router,
  logger
}) => {
  (0, _enablement.enableAssetInventoryRoute)(router, logger);
  (0, _delete.deleteAssetInventoryRoute)(router, logger);
  (0, _status.statusAssetInventoryRoute)(router, logger);
  (0, _install_data_view.installAssetInventoryDataViewRoute)(router, logger);
};
exports.registerAssetInventoryRoutes = registerAssetInventoryRoutes;