"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.doesLogsEndpointActionsIndexExist = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const doesLogsEndpointActionsIndexExist = async ({
  esClient,
  logger,
  indexName
}) => {
  try {
    const doesIndexExist = await esClient.indices.exists({
      index: indexName
    }, {
      meta: true
    });
    return doesIndexExist.statusCode !== 404;
  } catch (error) {
    var _error$type;
    const errorType = (_error$type = error === null || error === void 0 ? void 0 : error.type) !== null && _error$type !== void 0 ? _error$type : '';
    if (errorType !== 'index_not_found_exception') {
      logger.error(error);
      throw error;
    }
    return false;
  }
};
exports.doesLogsEndpointActionsIndexExist = doesLogsEndpointActionsIndexExist;