"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSelectIndexPatternGraph = void 0;
var _langgraph = require("@langchain/langgraph");
var _state = require("./state");
var _constants = require("./constants");
var _fetch_index_patterns = require("./nodes/fetch_index_patterns/fetch_index_patterns");
var _shortlist_index_patterns = require("./nodes/shortlist_index_patterns/shortlist_index_patterns");
var _analyse_index_pattern = require("./nodes/analyse_index_pattern/analyse_index_pattern");
var _select_index = require("./nodes/select_index/select_index");
var _analyse_index_pattern2 = require("../analyse_index_pattern/analyse_index_pattern");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSelectIndexPatternGraph = async ({
  createLlmInstance,
  esClient
}) => {
  const [analyzeIndexPatternGraph, shortlistIndexPatterns] = await Promise.all([(0, _analyse_index_pattern2.getAnalyzeIndexPatternGraph)({
    esClient,
    createLlmInstance
  }), (0, _shortlist_index_patterns.getShortlistIndexPatterns)({
    createLlmInstance
  })]);
  const graph = new _langgraph.StateGraph(_state.SelectIndexPatternAnnotation).addNode(_constants.GET_INDEX_PATTERNS, (0, _fetch_index_patterns.fetchIndexPatterns)({
    esClient
  }), {
    retryPolicy: {
      maxAttempts: 3
    }
  }).addNode(_constants.SHORTLIST_INDEX_PATTERNS, shortlistIndexPatterns).addNode(_constants.ANALYZE_INDEX_PATTERN, (0, _analyse_index_pattern.getAnalyzeIndexPattern)({
    analyzeIndexPatternGraph
  }), {
    retryPolicy: {
      maxAttempts: 3
    },
    subgraphs: [analyzeIndexPatternGraph]
  }).addNode(_constants.SELECT_INDEX_PATTERN, (0, _select_index.getSelectIndexPattern)(), {
    retryPolicy: {
      maxAttempts: 3
    }
  }).addEdge(_langgraph.START, _constants.GET_INDEX_PATTERNS).addEdge(_constants.GET_INDEX_PATTERNS, _constants.SHORTLIST_INDEX_PATTERNS).addConditionalEdges(_constants.SHORTLIST_INDEX_PATTERNS, state => {
    const {
      input
    } = state;
    if (input === undefined) {
      throw new Error('State input is undefined');
    }
    if (state.shortlistedIndexPatterns.length === 0) {
      return _langgraph.END;
    }
    return state.shortlistedIndexPatterns.map(indexPattern => {
      return new _langgraph.Send(_constants.ANALYZE_INDEX_PATTERN, {
        input: {
          question: input.question,
          indexPattern
        }
      });
    });
  }, {
    [_constants.ANALYZE_INDEX_PATTERN]: _constants.ANALYZE_INDEX_PATTERN,
    [_langgraph.END]: _langgraph.END
  }).addEdge(_constants.ANALYZE_INDEX_PATTERN, _constants.SELECT_INDEX_PATTERN).addEdge(_constants.SELECT_INDEX_PATTERN, _langgraph.END).compile();
  return graph;
};
exports.getSelectIndexPatternGraph = getSelectIndexPatternGraph;