"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteListItem = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _securitysolutionListHooks = require("@kbn/securitysolution-list-hooks");
var _use_app_toasts = require("../../common/hooks/use_app_toasts");
var _kibana = require("../../common/lib/kibana");
var _translations = require("../translations");
var _telemetry = require("../../common/lib/telemetry");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/value_list/components/delete_list_item.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const toastOptions = {
  toastLifeTimeMs: 5000
};
const DeleteListItem = ({
  id,
  value
}) => {
  const {
    addSuccess,
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const http = (0, _kibana.useKibana)().services.http;
  const deleteListItemMutation = (0, _securitysolutionListHooks.useDeleteListItemMutation)({
    onSuccess: () => {
      addSuccess(_translations.SUCCESSFULLY_DELETED_ITEM, toastOptions);
    },
    onError: error => {
      var _error$body$message, _error$body;
      addError(error, {
        title: error.message,
        toastMessage: (_error$body$message = error === null || error === void 0 ? void 0 : (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.message) !== null && _error$body$message !== void 0 ? _error$body$message : error.message
      });
    }
  });
  const deleteListItem = (0, _react.useCallback)(() => {
    (0, _telemetry.track)(_telemetry.METRIC_TYPE.COUNT, _telemetry.TELEMETRY_EVENT.DELETE_VALUE_LIST_ITEM);
    deleteListItemMutation.mutate({
      id,
      http
    });
  }, [deleteListItemMutation, id, http]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": _i18n.i18n.translate('xpack.securitySolution.valueLists.deleteListItemButton.ariaLabel', {
      defaultMessage: 'Delete list item'
    }),
    color: 'danger',
    onClick: deleteListItem,
    iconType: "trash",
    isLoading: deleteListItemMutation.isLoading,
    "data-test-subj": `delete-list-item-${value}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 5
    }
  });
};
exports.DeleteListItem = DeleteListItem;