"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getShowTimelineSelector = exports.getScrollToTopSelector = exports.getPinnedEventSelector = exports.getNotesSelector = exports.getNoteIdsSelector = exports.getEventIdToNoteIdsSelector = exports.getActiveTabSelector = void 0;
var _reselect = require("reselect");
var _timeline = require("../../../../../common/types/timeline");
var _selectors = require("../../../../common/store/app/selectors");
var _selectors2 = require("../../../store/selectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getActiveTabSelector = () => (0, _reselect.createSelector)(_selectors2.selectTimeline, timeline => {
  var _timeline$activeTab;
  return (_timeline$activeTab = timeline === null || timeline === void 0 ? void 0 : timeline.activeTab) !== null && _timeline$activeTab !== void 0 ? _timeline$activeTab : _timeline.TimelineTabs.query;
});
exports.getActiveTabSelector = getActiveTabSelector;
const getShowTimelineSelector = () => (0, _reselect.createSelector)(_selectors2.selectTimeline, timeline => {
  var _timeline$show;
  return (_timeline$show = timeline === null || timeline === void 0 ? void 0 : timeline.show) !== null && _timeline$show !== void 0 ? _timeline$show : false;
});
exports.getShowTimelineSelector = getShowTimelineSelector;
const getPinnedEventSelector = () => (0, _reselect.createSelector)(_selectors2.selectTimeline, timeline => {
  var _timeline$pinnedEvent;
  return Object.keys((_timeline$pinnedEvent = timeline === null || timeline === void 0 ? void 0 : timeline.pinnedEventIds) !== null && _timeline$pinnedEvent !== void 0 ? _timeline$pinnedEvent : {}).length;
});
exports.getPinnedEventSelector = getPinnedEventSelector;
const getNoteIdsSelector = () => (0, _reselect.createSelector)(_selectors2.selectTimeline, timeline => {
  var _timeline$noteIds;
  return (_timeline$noteIds = timeline === null || timeline === void 0 ? void 0 : timeline.noteIds) !== null && _timeline$noteIds !== void 0 ? _timeline$noteIds : [];
});
exports.getNoteIdsSelector = getNoteIdsSelector;
const getEventIdToNoteIdsSelector = () => (0, _reselect.createSelector)(_selectors2.selectTimeline, timeline => {
  var _timeline$eventIdToNo;
  return (_timeline$eventIdToNo = timeline === null || timeline === void 0 ? void 0 : timeline.eventIdToNoteIds) !== null && _timeline$eventIdToNo !== void 0 ? _timeline$eventIdToNo : {};
});
exports.getEventIdToNoteIdsSelector = getEventIdToNoteIdsSelector;
const getNotesSelector = () => (0, _reselect.createSelector)(_selectors.selectNotesById, notesById => Object.values(notesById));
exports.getNotesSelector = getNotesSelector;
const getScrollToTopSelector = () => (0, _reselect.createSelector)(_selectors2.selectTimeline, timeline => timeline === null || timeline === void 0 ? void 0 : timeline.scrollToTop);
exports.getScrollToTopSelector = getScrollToTopSelector;