"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getProviderActions = exports.ProviderItemActions = exports.FILTER_FOR_FIELD_PRESENT_CLASS_NAME = exports.EXCLUDE_CLASS_NAME = exports.ENABLE_CLASS_NAME = exports.EDIT_CLASS_NAME = exports.DELETE_CLASS_NAME = exports.CONVERT_TO_FIELD_CLASS_NAME = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _timeline = require("../../../../../common/api/timeline");
var _data_provider = require("./data_provider");
var _edit_data_provider = require("../../edit_data_provider");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/timeline/data_providers/provider_item_actions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EDIT_CLASS_NAME = exports.EDIT_CLASS_NAME = 'edit-data-provider';
const EXCLUDE_CLASS_NAME = exports.EXCLUDE_CLASS_NAME = 'exclude-data-provider';
const ENABLE_CLASS_NAME = exports.ENABLE_CLASS_NAME = 'enable-data-provider';
const FILTER_FOR_FIELD_PRESENT_CLASS_NAME = exports.FILTER_FOR_FIELD_PRESENT_CLASS_NAME = 'filter-for-field-present-data-provider';
const CONVERT_TO_FIELD_CLASS_NAME = exports.CONVERT_TO_FIELD_CLASS_NAME = 'convert-to-field-data-provider';
const DELETE_CLASS_NAME = exports.DELETE_CLASS_NAME = 'delete-data-provider';
const MyEuiPopover = (0, _styledComponents.default)(_eui.EuiPopover)`
  height: 100%;
  user-select: none;
`;
MyEuiPopover.displayName = 'MyEuiPopover';
const getProviderActions = ({
  andProviderId,
  browserFields,
  deleteItem,
  field,
  isEnabled,
  isExcluded,
  operator,
  onDataProviderEdited,
  onFilterForFieldPresent,
  providerId,
  timelineId,
  timelineType,
  toggleEnabled,
  toggleExcluded,
  toggleType,
  type,
  value
}) => [{
  id: 0,
  items: [{
    className: EDIT_CLASS_NAME,
    icon: 'pencil',
    name: i18n.EDIT_MENU_ITEM,
    panel: 1
  }, {
    className: EXCLUDE_CLASS_NAME,
    icon: `${isExcluded ? 'plusInCircle' : 'minusInCircle'}`,
    name: isExcluded ? i18n.INCLUDE_DATA_PROVIDER : i18n.EXCLUDE_DATA_PROVIDER,
    onClick: toggleExcluded
  }, {
    className: ENABLE_CLASS_NAME,
    icon: `${isEnabled ? 'eyeClosed' : 'eye'}`,
    name: isEnabled ? i18n.TEMPORARILY_DISABLE_DATA_PROVIDER : i18n.RE_ENABLE_DATA_PROVIDER,
    onClick: toggleEnabled
  }, {
    className: FILTER_FOR_FIELD_PRESENT_CLASS_NAME,
    icon: 'logstashFilter',
    name: i18n.FILTER_FOR_FIELD_PRESENT,
    onClick: onFilterForFieldPresent
  }, timelineType === _timeline.TimelineTypeEnum.template ? {
    className: CONVERT_TO_FIELD_CLASS_NAME,
    disabled: operator === _data_provider.IS_ONE_OF_OPERATOR,
    icon: 'visText',
    name: type === _timeline.DataProviderTypeEnum.template ? i18n.CONVERT_TO_FIELD : i18n.CONVERT_TO_TEMPLATE_FIELD,
    onClick: toggleType
  } : {
    name: null
  }, {
    className: DELETE_CLASS_NAME,
    icon: 'trash',
    name: i18n.DELETE_DATA_PROVIDER,
    onClick: deleteItem
  }].filter(item => item.name != null)
}, {
  content: browserFields != null && timelineId != null && onDataProviderEdited != null ? /*#__PURE__*/_react.default.createElement(_edit_data_provider.StatefulEditDataProvider, {
    andProviderId: andProviderId,
    browserFields: browserFields,
    field: field,
    isExcluded: isExcluded,
    onDataProviderEdited: onDataProviderEdited,
    operator: operator,
    providerId: providerId,
    timelineId: timelineId,
    value: value,
    type: type,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 9
    }
  }) : null,
  id: 1,
  title: i18n.EDIT_TITLE,
  width: 400
}];
exports.getProviderActions = getProviderActions;
class ProviderItemActions extends _react.default.PureComponent {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "onDataProviderEdited", ({
      andProviderId,
      excluded,
      field,
      id,
      operator,
      providerId,
      value,
      type
    }) => {
      if (this.props.onDataProviderEdited != null) {
        this.props.onDataProviderEdited({
          andProviderId,
          excluded,
          field,
          id,
          operator,
          providerId,
          value,
          type
        });
      }
      this.props.closePopover();
    });
    (0, _defineProperty2.default)(this, "onFilterForFieldPresent", () => {
      const {
        andProviderId,
        field,
        timelineId,
        providerId,
        value,
        type
      } = this.props;
      if (this.props.onDataProviderEdited != null) {
        this.props.onDataProviderEdited({
          andProviderId,
          excluded: false,
          field,
          id: `${timelineId}`,
          operator: _data_provider.EXISTS_OPERATOR,
          providerId,
          value,
          type
        });
      }
      this.props.closePopover();
    });
  }
  render() {
    const {
      andProviderId,
      browserFields,
      button,
      closePopover,
      deleteProvider,
      field,
      isEnabled,
      isExcluded,
      isOpen,
      operator,
      providerId,
      timelineId,
      timelineType,
      toggleEnabledProvider,
      toggleExcludedProvider,
      toggleTypeProvider,
      value,
      type
    } = this.props;
    const panelTree = getProviderActions({
      andProviderId,
      browserFields,
      deleteItem: deleteProvider,
      field,
      isEnabled,
      isExcluded,
      onDataProviderEdited: this.onDataProviderEdited,
      onFilterForFieldPresent: this.onFilterForFieldPresent,
      operator,
      providerId,
      timelineId,
      timelineType,
      toggleEnabled: toggleEnabledProvider,
      toggleExcluded: toggleExcludedProvider,
      toggleType: toggleTypeProvider,
      value,
      type
    });
    return /*#__PURE__*/_react.default.createElement(MyEuiPopover, {
      id: `popoverFor_${providerId}-${field}-${value}`,
      isOpen: isOpen,
      closePopover: closePopover,
      button: button,
      anchorPosition: "downCenter",
      panelPaddingSize: "none",
      ownFocus: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 224,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      css: {
        userSelect: 'none'
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 233,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
      initialPanelId: 0,
      panels: panelTree,
      "data-test-subj": "providerActions",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 234,
        columnNumber: 11
      }
    })));
  }
}
exports.ProviderItemActions = ProviderItemActions;