"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProcessHash = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _draggables = require("../../../../../common/components/draggables");
var _helpers = require("./helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/timeline/body/renderers/process_hash.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const HashFlexGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  margin: ${({
  theme
}) => theme.eui.euiSizeXS};
`;
const ProcessHash = exports.ProcessHash = /*#__PURE__*/_react.default.memo(({
  contextId,
  eventId,
  processHashSha256,
  scopeId
}) => {
  if ((0, _helpers.isNillEmptyOrNotFinite)(processHashSha256)) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(HashFlexGroup, {
    alignItems: "center",
    direction: "column",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    grow: false,
    component: "div",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
    scopeId: scopeId,
    contextId: contextId,
    eventId: eventId,
    field: "process.hash.sha256",
    iconType: "number",
    value: processHashSha256,
    fieldType: "keyword",
    isAggregatable: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 11
    }
  })));
});
ProcessHash.displayName = 'ProcessHash';