"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUpdateTimeline = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _fp = require("lodash/fp");
var _use_experimental_features = require("../../../common/hooks/use_experimental_features");
var _constants = require("../../../data_view_manager/constants");
var _use_select_data_view = require("../../../data_view_manager/hooks/use_select_data_view");
var _timeline2 = require("../../../../common/api/timeline");
var _helpers = require("../notes/helpers");
var _store = require("../../../sourcerer/store");
var _model = require("../../../sourcerer/store/model");
var _constants2 = require("../../../common/store/inputs/constants");
var _actions = require("../../../common/store/app/actions");
var _actions2 = require("../../../common/store/inputs/actions");
var _actions3 = require("../../store/actions");
var _default_date_settings = require("../../../common/utils/default_date_settings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useUpdateTimeline = () => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const selectDataView = (0, _use_select_data_view.useSelectDataView)();
  const {
    newDataViewPickerEnabled
  } = (0, _use_experimental_features.useEnableExperimental)();
  return (0, _react.useCallback)(
  // NOTE: this is only enabled for the data view picker test
  // eslint-disable-next-line complexity
  ({
    duplicate,
    id,
    forceNotes = false,
    from,
    notes,
    resolveTimelineConfig,
    timeline,
    to,
    ruleNote,
    ruleAuthor,
    preventSettingQuery
  }) => {
    let _timeline = timeline;
    if (duplicate) {
      // Reset the `updated` and `version` fields because a duplicated timeline has not been saved yet.
      // The `changed` field is set to true because the duplicated timeline needs to be saved.
      _timeline = {
        ...timeline,
        updated: undefined,
        changed: true,
        version: null
      };
    }
    if (newDataViewPickerEnabled) {
      selectDataView({
        id: _timeline.dataViewId,
        fallbackPatterns: _timeline.indexNames,
        scope: _constants.DataViewManagerScopeName.timeline
      });
    } else {
      if (!(0, _fp.isEmpty)(_timeline.indexNames) && !newDataViewPickerEnabled) {
        dispatch(_store.sourcererActions.setSelectedDataView({
          id: _model.SourcererScopeName.timeline,
          selectedDataViewId: _timeline.dataViewId,
          selectedPatterns: _timeline.indexNames
        }));
      }
    }
    if (_timeline.status === _timeline2.TimelineStatusEnum.immutable && _timeline.timelineType === _timeline2.TimelineTypeEnum.template) {
      dispatch((0, _actions2.setRelativeRangeDatePicker)({
        id: _constants2.InputsModelId.timeline,
        fromStr: 'now-24h',
        toStr: 'now',
        from: _default_date_settings.DEFAULT_FROM_MOMENT.toISOString(),
        to: _default_date_settings.DEFAULT_TO_MOMENT.toISOString()
      }));
    } else {
      dispatch((0, _actions2.setTimelineRangeDatePicker)({
        from,
        to
      }));
    }
    dispatch((0, _actions3.addTimeline)({
      id,
      timeline: _timeline,
      resolveTimelineConfig,
      savedTimeline: duplicate
    }));
    if (!preventSettingQuery && _timeline.kqlQuery != null && _timeline.kqlQuery.filterQuery != null && _timeline.kqlQuery.filterQuery.kuery != null && _timeline.kqlQuery.filterQuery.kuery.expression !== '') {
      var _timeline$kqlQuery$fi;
      dispatch((0, _actions3.applyKqlFilterQuery)({
        id,
        filterQuery: {
          kuery: {
            kind: (_timeline$kqlQuery$fi = _timeline.kqlQuery.filterQuery.kuery.kind) !== null && _timeline$kqlQuery$fi !== void 0 ? _timeline$kqlQuery$fi : 'kuery',
            expression: _timeline.kqlQuery.filterQuery.kuery.expression || ''
          },
          serializedQuery: _timeline.kqlQuery.filterQuery.serializedQuery || ''
        }
      }));
    }
    if (duplicate && ruleNote != null && !(0, _fp.isEmpty)(ruleNote)) {
      const newNote = (0, _helpers.createNote)({
        newNote: ruleNote,
        user: ruleAuthor || 'elastic'
      });
      dispatch((0, _actions.updateNote)({
        note: newNote
      }));
      dispatch((0, _actions3.addNote)({
        noteId: newNote.id,
        id
      }));
    }
    if (!duplicate || forceNotes) {
      dispatch((0, _actions.addNotes)({
        notes: notes != null ? notes.map(note => {
          var _note$eventId, _note$timelineId;
          return {
            created: note.created != null ? new Date(note.created) : new Date(),
            id: note.noteId,
            lastEdit: note.updated != null ? new Date(note.updated) : new Date(),
            note: note.note || '',
            user: note.updatedBy || 'unknown',
            saveObjectId: note.noteId,
            version: note.version,
            eventId: (_note$eventId = note.eventId) !== null && _note$eventId !== void 0 ? _note$eventId : null,
            timelineId: (_note$timelineId = note.timelineId) !== null && _note$timelineId !== void 0 ? _note$timelineId : null
          };
        }) : []
      }));
    }
  }, [dispatch, newDataViewPickerEnabled, selectDataView]);
};
exports.useUpdateTimeline = useUpdateTimeline;