"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBlockListContext = void 0;
var _react = require("react");
var _block_list_provider = require("../containers/block_list_provider");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Hook to retrieve {@link BlockListContext}
 */
const useBlockListContext = () => {
  const contextValue = (0, _react.useContext)(_block_list_provider.BlockListContext);
  if (!contextValue) {
    throw new Error('BlockListContext can only be used within BlockListContext provider');
  }
  return contextValue;
};
exports.useBlockListContext = useBlockListContext;