"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddToBlockListContextMenu = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _user_privileges = require("../../../../common/components/user_privileges");
var _use_block_list_context = require("../../indicators/hooks/use_block_list_context");
var _use_set_url_params = require("../../../../management/components/artifact_list_page/hooks/use_set_url_params");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/threat_intelligence/modules/block_list/components/add_to_block_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * Add to blocklist functionality displayed as a ContextMenuItem (in the main indicators table row and in the indicator flyout).
 * The entry is disabled is the filehash isn't sha256, sha1 or md5.
 * When clicking on the ContextMenuItem, the indicator filehash value is saved in context.
 * The flyout is shown by adding a parameter to the url.
 */
const AddToBlockListContextMenu = ({
  data,
  'data-test-subj': dataTestSub,
  onClick
}) => {
  const canWriteBlocklist = (0, _user_privileges.useUserPrivileges)().endpointPrivileges.canWriteBlocklist;
  const {
    setBlockListIndicatorValue
  } = (0, _use_block_list_context.useBlockListContext)();
  const setUrlParams = (0, _use_set_url_params.useSetUrlParams)();
  const menuItemClicked = () => {
    onClick();
    setBlockListIndicatorValue(data);
    setUrlParams({
      show: 'create'
    });
  };
  const disabled = !canWriteBlocklist || data === null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "addToBlocklist",
    onClick: () => menuItemClicked(),
    "data-test-subj": dataTestSub,
    disabled: disabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Add blocklist entry",
    id: "xpack.securitySolution.threatIntelligence.addToBlockList",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 7
    }
  }));
};
exports.AddToBlockListContextMenu = AddToBlockListContextMenu;