"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSocTrends = void 0;
var _fp = require("lodash/fp");
var _react = require("react");
var _use_selector = require("../../../../../common/hooks/use_selector");
var _store = require("../../../../../common/store");
var _use_global_time = require("../../../../../common/containers/use_global_time");
var _use_cases_mttr = require("./use_cases_mttr");
var _use_critical_alerts = require("./use_critical_alerts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSocTrends = ({
  skip = false,
  signalIndexName
}) => {
  const {
    to,
    from,
    setQuery,
    deleteQuery
  } = (0, _use_global_time.useGlobalTime)();
  // TODO: remove empty compare times when socTrendsEnabled feature flag removed
  // this hook will not be called if socTrendsEnabled = false so the empty times don't matter
  const {
    from: fromCompare = '',
    to: toCompare = ''
  } = (0, _use_selector.useDeepEqualSelector)(state => (0, _fp.pick)(['from', 'to'], _store.inputsSelectors.socTrendsTimeRangeSelector(state)));
  const casesMttr = (0, _use_cases_mttr.useCasesMttr)({
    deleteQuery,
    from,
    fromCompare,
    setQuery,
    skip,
    to,
    toCompare
  });
  const criticalAlerts = (0, _use_critical_alerts.useCriticalAlerts)({
    from,
    fromCompare,
    skip,
    signalIndexName,
    to,
    toCompare
  });
  const latestUpdate = (0, _react.useMemo)(() => Math.max(...[casesMttr.updatedAt, criticalAlerts.updatedAt]), [casesMttr.updatedAt, criticalAlerts.updatedAt]);
  const isUpdating = (0, _react.useMemo)(() => casesMttr.isLoading || criticalAlerts.isLoading, [casesMttr.isLoading, criticalAlerts.isLoading]);
  return {
    stats: [casesMttr, criticalAlerts],
    isUpdating,
    latestUpdate
  };
};
exports.useSocTrends = useSocTrends;