"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTopicId = void 0;
var _reactRouterDom = require("react-router-dom");
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Hook that returns the topic id from the URL, or the default topic id if none is present
 * This is the Single Source of Truth for the topic id
 */
const useTopicId = () => {
  const {
    topicId = _constants.OnboardingTopicId.default
  } = (0, _reactRouterDom.useParams)();
  return topicId;
};
exports.useTopicId = useTopicId;