"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.checkArtifactHasData = void 0;
var _query_client_provider = require("../../../common/containers/query_client/query_client_provider");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Checks to see if a given type of artifact has data.
 *
 * Note: this service function will suppress API errors (if any) and return `false` if one is encountered
 *
 * @param artifactApiClient
 * @param queryOptions
 */
const checkArtifactHasData = (artifactApiClient, queryOptions = {}) => {
  return _query_client_provider.securitySolutionQueryClient.fetchQuery({
    queryKey: ['get-artifact-has-data', artifactApiClient],
    ...queryOptions,
    queryFn: async () => {
      try {
        return await artifactApiClient.hasData();
      } catch (error) {
        window.console.log(error);
        // Ignores possible failures and returns `false` if any exception was encountered
        return false;
      }
    }
  });
};
exports.checkArtifactHasData = checkArtifactHasData;