"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TrustedAppsList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _user_privileges = require("../../../../common/components/user_privileges");
var _kibana = require("../../../../common/lib/kibana");
var _artifact_list_page = require("../../../components/artifact_list_page");
var _service = require("../service");
var _form = require("./components/form");
var _constants = require("../constants");
var _artifacts_docs_link = require("./components/artifacts_docs_link");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/trusted_apps/view/trusted_apps_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TRUSTED_APPS_PAGE_LABELS = {
  pageTitle: _i18n.i18n.translate('xpack.securitySolution.trustedApps.pageTitle', {
    defaultMessage: 'Trusted applications'
  }),
  pageAboutInfo: _i18n.i18n.translate('xpack.securitySolution.trustedApps.pageAboutInfo', {
    defaultMessage: 'Add a trusted application to improve performance or alleviate conflicts with other applications running on your hosts. Trusted applications may still generate alerts in some cases.'
  }),
  pageAddButtonTitle: _i18n.i18n.translate('xpack.securitySolution.trustedApps.pageAddButtonTitle', {
    defaultMessage: 'Add trusted application'
  }),
  getShowingCountLabel: total => _i18n.i18n.translate('xpack.securitySolution.trustedApps.showingTotal', {
    defaultMessage: 'Showing {total} {total, plural, one {trusted application} other {trusted applications}}',
    values: {
      total
    }
  }),
  cardActionEditLabel: _i18n.i18n.translate('xpack.securitySolution.trustedApps.cardActionEditLabel', {
    defaultMessage: 'Edit trusted application'
  }),
  cardActionDeleteLabel: _i18n.i18n.translate('xpack.securitySolution.trustedApps.cardActionDeleteLabel', {
    defaultMessage: 'Delete trusted application'
  }),
  flyoutCreateTitle: _i18n.i18n.translate('xpack.securitySolution.trustedApps.flyoutCreateTitle', {
    defaultMessage: 'Add trusted application'
  }),
  flyoutEditTitle: _i18n.i18n.translate('xpack.securitySolution.trustedApps.flyoutEditTitle', {
    defaultMessage: 'Edit trusted application'
  }),
  flyoutCreateSubmitButtonLabel: _i18n.i18n.translate('xpack.securitySolution.trustedApps.flyoutCreateSubmitButtonLabel', {
    defaultMessage: 'Add trusted application'
  }),
  flyoutCreateSubmitSuccess: ({
    name
  }) => _i18n.i18n.translate('xpack.securitySolution.trustedApps.flyoutCreateSubmitSuccess', {
    defaultMessage: '"{name}" has been added to your trusted applications.',
    values: {
      name
    }
  }),
  flyoutEditSubmitSuccess: ({
    name
  }) => _i18n.i18n.translate('xpack.securitySolution.trustedApps.flyoutEditSubmitSuccess', {
    defaultMessage: '"{name}" has been updated.',
    values: {
      name
    }
  }),
  flyoutDowngradedLicenseDocsInfo: securitySolutionDocsLinks => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.trustedApps.flyoutDowngradedLicenseDocsInfo",
      defaultMessage: "For more information, see our ",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      target: "_blank",
      href: `${securitySolutionDocsLinks.trustedApps}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.trustedApps.flyoutDowngradedLicenseDocsLink",
      defaultMessage: "Trusted applications documentation",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 11
      }
    })));
  },
  deleteActionSuccess: itemName => _i18n.i18n.translate('xpack.securitySolution.trustedApps.deleteSuccess', {
    defaultMessage: '"{itemName}" has been removed from trusted applications.',
    values: {
      itemName
    }
  }),
  emptyStateTitleNoEntries: _i18n.i18n.translate('xpack.securitySolution.trustedApps.emptyStateTitleNoEntries', {
    defaultMessage: 'There are no trusted applications to display.'
  }),
  emptyStateTitle: _i18n.i18n.translate('xpack.securitySolution.trustedApps.emptyStateTitle', {
    defaultMessage: 'Add your first trusted application'
  }),
  emptyStateInfo: _i18n.i18n.translate('xpack.securitySolution.trustedApps.emptyStateInfo', {
    defaultMessage: 'Add a trusted application to improve performance or alleviate conflicts with other applications running on your hosts. Trusted applications may still generate alerts in some cases.'
  }),
  emptyStatePrimaryButtonLabel: _i18n.i18n.translate('xpack.securitySolution.trustedApps.emptyStatePrimaryButtonLabel', {
    defaultMessage: 'Add trusted application'
  }),
  searchPlaceholderInfo: _i18n.i18n.translate('xpack.securitySolution.trustedApps.searchPlaceholderInfo', {
    defaultMessage: 'Search on the fields below: name, description, value'
  })
};
const TrustedAppsList = exports.TrustedAppsList = /*#__PURE__*/(0, _react.memo)(() => {
  const {
    canWriteTrustedApplications
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  const http = (0, _kibana.useHttp)();
  const trustedAppsApiClient = _service.TrustedAppsApiClient.getInstance(http);
  return /*#__PURE__*/_react.default.createElement(_artifact_list_page.ArtifactListPage, {
    apiClient: trustedAppsApiClient,
    ArtifactFormComponent: _form.TrustedAppsForm,
    labels: TRUSTED_APPS_PAGE_LABELS,
    "data-test-subj": "trustedAppsListPage",
    flyoutSize: "l",
    searchableFields: _constants.SEARCHABLE_FIELDS,
    secondaryPageInfo: /*#__PURE__*/_react.default.createElement(_artifacts_docs_link.TrustedAppsArtifactsDocsLink, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 130,
        columnNumber: 26
      }
    }),
    allowCardDeleteAction: canWriteTrustedApplications,
    allowCardEditAction: canWriteTrustedApplications,
    allowCardCreateAction: canWriteTrustedApplications,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 5
    }
  });
});
TrustedAppsList.displayName = 'TrustedAppsList';