"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfirmUpdate = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/policy/view/policy_settings_layout/components/policy_form_confirm_update.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ConfirmUpdate = exports.ConfirmUpdate = /*#__PURE__*/_react.default.memo(({
  endpointCount,
  onCancel,
  onConfirm
}) => {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    title: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.updateConfirm.title', {
      defaultMessage: 'Save and deploy changes'
    }),
    titleProps: {
      id: modalTitleId
    },
    "data-test-subj": "policyDetailsConfirmModal",
    onCancel: onCancel,
    onConfirm: onConfirm,
    confirmButtonText: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.updateConfirm.confirmButtonTitle', {
      defaultMessage: 'Save and deploy changes'
    }),
    cancelButtonText: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.updateConfirm.cancelButtonTitle', {
      defaultMessage: 'Cancel'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 21,
      columnNumber: 5
    }
  }, endpointCount > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "policyDetailsWarningCallout",
    title: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.updateConfirm.warningTitle', {
      defaultMessage: 'This action will update {endpointCount, plural, one {# endpoint} other {# endpoints}}',
      values: {
        endpointCount
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.policy.details.updateConfirm.warningMessage",
    defaultMessage: "Saving these changes will apply updates to all endpoints assigned to this agent policy.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.policy.details.updateConfirm.message",
    defaultMessage: "This action cannot be undone. Are you sure you wish to continue?",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 9
    }
  })));
});
ConfirmUpdate.displayName = 'ConfirmUpdate';