"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSendExecuteEndpoint = void 0;
var _reactQuery = require("@tanstack/react-query");
var _kibana = require("../../../common/lib/kibana");
var _constants = require("../../../../common/endpoint/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSendExecuteEndpoint = options => {
  return (0, _reactQuery.useMutation)(executeActionReqBody => {
    return _kibana.KibanaServices.get().http.post(_constants.EXECUTE_ROUTE, {
      body: JSON.stringify(executeActionReqBody),
      version: '2023-10-31'
    });
  }, options);
};
exports.useSendExecuteEndpoint = useSendExecuteEndpoint;