"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObjectContent = exports.FormattedError = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _coreHttpBrowser = require("@kbn/core-http-browser");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/formatted_error/formatted_error.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ObjectContent = exports.ObjectContent = /*#__PURE__*/(0, _react.memo)(({
  data
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 18,
      columnNumber: 5
    }
  }, Object.entries(data).map(([key, value]) => {
    return /*#__PURE__*/_react.default.createElement("div", {
      key: key,
      className: "eui-textBreakWord",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 21,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 22,
        columnNumber: 13
      }
    }, key), ': ', value);
  }));
});
ObjectContent.displayName = 'ObjectContent';
/**
 * A general component for formatting errors. Recognizes different types of errors and displays
 * their information.
 */
const FormattedError = exports.FormattedError = /*#__PURE__*/(0, _react.memo)(({
  error,
  'data-test-subj': dataTestSubj
}) => {
  return (0, _react.useMemo)(() => {
    let content = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, error.message);
    if ((0, _coreHttpBrowser.isHttpFetchError)(error)) {
      var _error$response, _error$response2;
      content = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 50,
          columnNumber: 13
        }
      }, `${(_error$response = error.response) === null || _error$response === void 0 ? void 0 : _error$response.status}: ${(_error$response2 = error.response) === null || _error$response2 === void 0 ? void 0 : _error$response2.statusText}`), error.body && /*#__PURE__*/_react.default.createElement(ObjectContent, {
        data: error.body,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 51,
          columnNumber: 28
        }
      }));
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      "data-test-subj": dataTestSubj,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 14
      }
    }, content);
  }, [dataTestSubj, error]);
});
FormattedError.displayName = 'FormattedError';