"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SHARED_TRUNCATION_STYLE = exports.PENDING_ACTIONS_CONFIG = exports.CUSTOM_SCRIPTS_CONFIG = void 0;
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Shared CSS style for text truncation with ellipsis
 */
const SHARED_TRUNCATION_STYLE = exports.SHARED_TRUNCATION_STYLE = (0, _react.css)({
  display: '-webkit-box',
  overflow: 'hidden',
  WebkitBoxOrient: 'vertical',
  WebkitLineClamp: 1,
  lineClamp: 1,
  // standardized fallback for modern Firefox
  textOverflow: 'ellipsis',
  whiteSpace: 'normal'
});

/**
 * Configuration for CustomScriptSelector
 */
const CUSTOM_SCRIPTS_CONFIG = exports.CUSTOM_SCRIPTS_CONFIG = {
  initialLabel: _i18n.i18n.translate('xpack.securitySolution.consoleArgumentSelectors.customScriptSelector.initialDisplayLabel', {
    defaultMessage: 'Click to select script'
  }),
  tooltipText: _i18n.i18n.translate('xpack.securitySolution.consoleArgumentSelectors.customScriptSelector.tooltipText', {
    defaultMessage: 'Click to choose script'
  }),
  minWidth: 400,
  rowHeight: 60,
  selectableId: 'options-combobox'
};

/**
 * Configuration for PendingActionsSelector
 */
const PENDING_ACTIONS_CONFIG = exports.PENDING_ACTIONS_CONFIG = {
  initialLabel: _i18n.i18n.translate('xpack.securitySolution.consoleArgumentSelectors.pendingActionsSelector.initialDisplayLabel', {
    defaultMessage: 'Click to select action'
  }),
  tooltipText: _i18n.i18n.translate('xpack.securitySolution.consoleArgumentSelectors.pendingActionsSelector.tooltipText', {
    defaultMessage: 'Click to choose pending action to cancel'
  }),
  minWidth: 500,
  rowHeight: 70,
  selectableId: 'pending-actions-combobox'
};