"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CommandExecutionResult = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _classnames = _interopRequireDefault(require("classnames"));
var _use_data_test_subj = require("../hooks/state_selectors/use_data_test_subj");
var _use_test_id_generator = require("../../../hooks/use_test_id_generator");
var _console_text = require("./console_text");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/console/components/command_execution_result.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const COMMAND_EXECUTION_RESULT_SUCCESS_TITLE = _i18n.i18n.translate('xpack.securitySolution.commandExecutionResult.successTitle', {
  defaultMessage: 'Action completed.'
});
const COMMAND_EXECUTION_SUBMIT_RESULT_SUCCESS_TITLE = _i18n.i18n.translate('xpack.securitySolution.commandExecutionSubmitResult.successTitle', {
  defaultMessage: 'Action successfully submitted.'
});
const COMMAND_EXECUTION_RESULT_FAILURE_TITLE = _i18n.i18n.translate('xpack.securitySolution.commandExecutionResult.failureTitle', {
  defaultMessage: 'Action failed.'
});
const COMMAND_EXECUTION_RESULT_PENDING = _i18n.i18n.translate('xpack.securitySolution.commandExecutionResult.pending', {
  defaultMessage: 'Action pending.'
});
/**
 * A component that can be used by consumers of the Console to format the result of a command.
 * Applies consistent structure, colors and formatting, and includes ability to set a title and
 * whether the result is a success or failure.
 */
const CommandExecutionResult = exports.CommandExecutionResult = /*#__PURE__*/(0, _react.memo)(({
  showAs = 'success',
  title,
  showTitle = true,
  'data-test-subj': dataTestSubj,
  className,
  children,
  agentType
}) => {
  const consoleDataTestSubj = (0, _use_data_test_subj.useDataTestSubj)();
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj !== null && dataTestSubj !== void 0 ? dataTestSubj : consoleDataTestSubj);
  const panelClassName = (0, _react.useMemo)(() => {
    return (0, _classnames.default)({
      'eui-displayInlineBlock': showAs === 'pending',
      // This class name (font-family-code) is a utility class defined in `Console.tsx`
      'font-family-code': true,
      [className || '_']: Boolean(className)
    });
  }, [className, showAs]);
  const titleMessage = (0, _react.useMemo)(() => {
    if (title) {
      return title;
    }
    if (showAs === 'success') {
      return agentType === 'crowdstrike' ? COMMAND_EXECUTION_SUBMIT_RESULT_SUCCESS_TITLE : COMMAND_EXECUTION_RESULT_SUCCESS_TITLE;
    } else {
      return COMMAND_EXECUTION_RESULT_FAILURE_TITLE;
    }
  }, [agentType, showAs, title]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    paddingSize: "none",
    borderRadius: "none",
    color: "transparent",
    className: panelClassName,
    "data-test-subj": dataTestSubj ? dataTestSubj : getTestId('commandExecutionResult'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 7
    }
  }, showAs === 'pending' ? /*#__PURE__*/_react.default.createElement(_console_text.ConsoleText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 11
    }
  }, children !== null && children !== void 0 ? children : COMMAND_EXECUTION_RESULT_PENDING) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showTitle && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_console_text.ConsoleText, {
    color: showAs === 'success' ? 'success' : 'danger',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 17
    }
  }, titleMessage), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 17
    }
  })), children));
});
CommandExecutionResult.displayName = 'CommandExecutionResult';