"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ArtifactFlyout = exports.ARTIFACT_FLYOUT_LABELS = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _securitysolutionHookUtils = require("@kbn/securitysolution-hook-utils");
var _reactRouterDom = require("react-router-dom");
var _artifacts = require("../../../../../common/endpoint/service/artifacts");
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
var _use_mark_workflow_insight_as_remediated = require("../hooks/use_mark_workflow_insight_as_remediated");
var _use_url_params = require("../../../hooks/use_url_params");
var _use_is_flyout_opened = require("../hooks/use_is_flyout_opened");
var _use_test_id_generator = require("../../../hooks/use_test_id_generator");
var _use_set_url_params = require("../hooks/use_set_url_params");
var _management_page_loader = require("../../management_page_loader");
var _kibana = require("../../../../common/lib/kibana");
var _utils = require("../../../../../common/endpoint/service/artifacts/utils");
var _use_with_artifact_submit_data = require("../hooks/use_with_artifact_submit_data");
var _use_is_artifact_allowed_per_policy_usage = require("../hooks/use_is_artifact_allowed_per_policy_usage");
var _artifacts2 = require("../../../hooks/artifacts");
var _artifact_confirm_modal = require("./artifact_confirm_modal");
var _user_privileges = require("../../../../common/components/user_privileges");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/artifact_list_page/components/artifact_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ARTIFACT_FLYOUT_LABELS = exports.ARTIFACT_FLYOUT_LABELS = Object.freeze({
  flyoutEditTitle: _i18n.i18n.translate('xpack.securitySolution.artifactListPage.flyoutEditTitle', {
    defaultMessage: 'Add artifact'
  }),
  flyoutCreateTitle: _i18n.i18n.translate('xpack.securitySolution.artifactListPage.flyoutCreateTitle', {
    defaultMessage: 'Create artifact'
  }),
  flyoutCancelButtonLabel: _i18n.i18n.translate('xpack.securitySolution.artifactListPage.flyoutCancelButtonLabel', {
    defaultMessage: 'Cancel'
  }),
  flyoutCreateSubmitButtonLabel: _i18n.i18n.translate('xpack.securitySolution.artifactListPage.flyoutCreateSubmitButtonLabel', {
    defaultMessage: 'Add'
  }),
  flyoutEditSubmitButtonLabel: _i18n.i18n.translate('xpack.securitySolution.artifactListPage.flyoutEditSubmitButtonLabel', {
    defaultMessage: 'Save'
  }),
  flyoutDowngradedLicenseTitle: _i18n.i18n.translate('xpack.securitySolution.artifactListPage.expiredLicenseTitle', {
    defaultMessage: 'Expired License'
  }),
  flyoutDowngradedLicenseInfo: _i18n.i18n.translate('xpack.securitySolution.artifactListPage.flyoutDowngradedLicenseInfo', {
    defaultMessage: 'Your Kibana license has been downgraded. Future policy configurations will now be globally assigned to all policies.'
  }),
  /**
   * This should be set to a sentence that includes a link to the documentation page for this specific artifact type.
   *
   * @example
   * // in a component
   * () => {
   *   const { docLinks } = useKibana().services;
   *   return (
   *     <FormattedMessage
   *        id="some-id-1"
   *        defaultMessage="For more information, see our {link}."
   *        value={{
   *          link: <EuiLink target="_blank" href={`${docLinks.links.securitySolution.eventFilters}`}>
   *            <FormattedMessage id="dome-id-2" defaultMessage="Event filters documentation" />
   *          </EuiLink>
   *        }}
   *     />
   *   );
   * }
   */
  flyoutDowngradedLicenseDocsInfo: _ => _i18n.i18n.translate('xpack.securitySolution.artifactListPage.flyoutDowngradedLicenseDocsInfo', {
    defaultMessage: 'For more information, see our documentation.'
  }),
  flyoutEditItemLoadFailure: errorMessage => _i18n.i18n.translate('xpack.securitySolution.artifactListPage.flyoutEditItemLoadFailure', {
    defaultMessage: 'Failed to retrieve item for edit. Reason: {errorMessage}',
    values: {
      errorMessage
    }
  }),
  /**
   * A function returning the label for the success message toast
   * @param itemName
   * @example
   *  ({ name }) => i18n.translate('xpack.securitySolution.some_page.flyoutCreateSubmitSuccess', {
   *    defaultMessage: '"{name}" has been added.',
   *    values: { name },
   *  })
   */
  flyoutCreateSubmitSuccess: ({
    name
  }) => _i18n.i18n.translate('xpack.securitySolution.some_page.flyoutCreateSubmitSuccess', {
    defaultMessage: '"{name}" has been added.',
    values: {
      name
    }
  }),
  /**
   * Returns the edit success message for the toast
   * @param item
   * @example
   *  ({ name }) =>
   *    i18n.translate('xpack.securitySolution.some_page.flyoutEditSubmitSuccess', {
   *    defaultMessage: '"{name}" has been updated.',
   *    values: { name },
   *  })
   */
  flyoutEditSubmitSuccess: ({
    name
  }) => _i18n.i18n.translate('xpack.securitySolution.artifactListPage.flyoutEditSubmitSuccess', {
    defaultMessage: '"{name}" has been updated.',
    values: {
      name
    }
  })
});
const createFormInitialState = (listId, item) => {
  return {
    isValid: false,
    item: item !== null && item !== void 0 ? item : (0, _utils.createExceptionListItemForCreate)(listId)
  };
};
/**
 * Show the flyout based on URL params
 */
const ArtifactFlyout = exports.ArtifactFlyout = /*#__PURE__*/(0, _react.memo)(({
  apiClient,
  item,
  FormComponent,
  onSuccess,
  onClose,
  submitHandler,
  labels: _labels = {},
  'data-test-subj': dataTestSubj,
  size = 'm'
}) => {
  var _urlParams$itemId, _formState$item$tags, _location$state3;
  const {
    docLinks: {
      links: {
        securitySolution
      }
    }
  } = (0, _kibana.useKibana)().services;
  const location = (0, _reactRouterDom.useLocation)();
  const [sourceInsight, setSourceInsight] = (0, _react.useState)(null);
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const toasts = (0, _kibana.useToasts)();
  const isFlyoutOpened = (0, _use_is_flyout_opened.useIsFlyoutOpened)();
  const setUrlParams = (0, _use_set_url_params.useSetUrlParams)();
  const {
    urlParams
  } = (0, _use_url_params.useUrlParams)();
  const isMounted = (0, _securitysolutionHookUtils.useIsMounted)();
  const isSpaceAwarenessEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('endpointManagementSpaceAwarenessEnabled');
  const canManageGlobalArtifacts = (0, _user_privileges.useUserPrivileges)().endpointPrivileges.canManageGlobalArtifacts;
  const labels = (0, _react.useMemo)(() => {
    return {
      ...ARTIFACT_FLYOUT_LABELS,
      ..._labels
    };
  }, [_labels]);
  // TODO:PT Refactor internal/external state into the `useWithArtifactSubmitData()` hook
  const [externalIsSubmittingData, setExternalIsSubmittingData] = (0, _react.useState)(false);
  const [externalSubmitHandlerError, setExternalSubmitHandlerError] = (0, _react.useState)(undefined);
  const [showConfirmModal, setShowConfirmModal] = (0, _react.useState)(false);
  const isEditFlow = urlParams.show === 'edit';
  const formMode = isEditFlow ? 'edit' : 'create';
  const {
    isLoading: internalIsSubmittingData,
    mutateAsync: submitData,
    error: internalSubmitError
  } = (0, _use_with_artifact_submit_data.useWithArtifactSubmitData)(apiClient, formMode);
  const {
    mutateAsync: markInsightAsRemediated
  } = (0, _use_mark_workflow_insight_as_remediated.useMarkInsightAsRemediated)(sourceInsight === null || sourceInsight === void 0 ? void 0 : sourceInsight.back_url);
  const isSubmittingData = (0, _react.useMemo)(() => {
    return submitHandler ? externalIsSubmittingData : internalIsSubmittingData;
  }, [externalIsSubmittingData, internalIsSubmittingData, submitHandler]);
  const submitError = (0, _react.useMemo)(() => {
    return submitHandler ? externalSubmitHandlerError : internalSubmitError;
  }, [externalSubmitHandlerError, internalSubmitError, submitHandler]);
  const {
    isRefetching: isLoadingItemForEdit,
    error,
    refetch: fetchItemForEdit
  } = (0, _artifacts2.useGetArtifact)(apiClient, (_urlParams$itemId = urlParams.itemId) !== null && _urlParams$itemId !== void 0 ? _urlParams$itemId : '', undefined, {
    // We don't want to run this at soon as the component is rendered. `refetch` is called
    // a little later if determined we're in `edit` mode
    enabled: false
  });
  const [formState, setFormState] = (0, _react.useState)(() => {
    const initialFormState = createFormInitialState(apiClient.listId, item);

    // for Create Mode: If user is not able to manage global artifacts then the initial item should be per-policy
    if (!item && isSpaceAwarenessEnabled && !canManageGlobalArtifacts) {
      var _initialFormState$ite;
      initialFormState.item.tags = ((_initialFormState$ite = initialFormState.item.tags) !== null && _initialFormState$ite !== void 0 ? _initialFormState$ite : []).filter(tag => tag !== _artifacts.GLOBAL_ARTIFACT_TAG);
    }
    return initialFormState;
  });
  const showExpiredLicenseBanner = (0, _use_is_artifact_allowed_per_policy_usage.useIsArtifactAllowedPerPolicyUsage)({
    tags: (_formState$item$tags = formState.item.tags) !== null && _formState$item$tags !== void 0 ? _formState$item$tags : []
  }, formMode);
  const hasItemDataForEdit = (0, _react.useMemo)(() => {
    // `item_id` will not be defined for a `create` flow, so we use it below to determine if we
    // are still attempting to load the item for edit from the api
    return !!item || !!formState.item.item_id;
  }, [formState.item.item_id, item]);
  const isInitializing = (0, _react.useMemo)(() => {
    return isEditFlow && !hasItemDataForEdit;
  }, [hasItemDataForEdit, isEditFlow]);
  const handleFlyoutClose = (0, _react.useCallback)(() => {
    if (isSubmittingData) {
      return;
    }

    // `undefined` will cause params to be dropped from url
    setUrlParams({
      ...urlParams,
      itemId: undefined,
      show: undefined
    }, true);
    onClose();
  }, [isSubmittingData, onClose, setUrlParams, urlParams]);
  const handleFormComponentOnChange = (0, _react.useCallback)(({
    item: updatedItem,
    isValid,
    confirmModalLabels
  }) => {
    if (isMounted()) {
      setFormState({
        item: updatedItem,
        isValid,
        confirmModalLabels
      });
    }
  }, [isMounted]);
  const handleSuccess = (0, _react.useCallback)(async result => {
    toasts.addSuccess(isEditFlow ? labels.flyoutEditSubmitSuccess(result) : labels.flyoutCreateSubmitSuccess(result));

    // Check if this artifact creation was opened from an endpoint insight
    try {
      if (sourceInsight !== null && sourceInsight !== void 0 && sourceInsight.id) {
        await markInsightAsRemediated({
          insightId: sourceInsight.id
        });
        return;
      }
    } catch {
      setSourceInsight(null);
    }
    if (isMounted()) {
      // Close the flyout
      // `undefined` will cause params to be dropped from url
      setUrlParams({
        ...urlParams,
        itemId: undefined,
        show: undefined
      }, true);
      onSuccess();
    }
  }, [isEditFlow, isMounted, labels, markInsightAsRemediated, onSuccess, setUrlParams, sourceInsight, toasts, urlParams]);
  const handleSubmitClick = (0, _react.useCallback)(() => {
    if (submitHandler) {
      setExternalIsSubmittingData(true);
      submitHandler(formState.item, formMode).then(handleSuccess).catch(submitHandlerError => {
        if (isMounted()) {
          setExternalSubmitHandlerError(submitHandlerError);
        }
      }).finally(() => {
        if (isMounted()) {
          setExternalIsSubmittingData(false);
        }
      });
    } else if (formState.confirmModalLabels) {
      setShowConfirmModal(true);
    } else {
      submitData(formState.item).then(handleSuccess);
    }
  }, [formMode, formState.item, formState.confirmModalLabels, handleSuccess, isMounted, submitData, submitHandler]);
  const confirmModalOnSuccess = (0, _react.useCallback)(() => submitData(formState.item).then(handleSuccess), [submitData, formState.item, handleSuccess]);
  const confirmModal = (0, _react.useMemo)(() => {
    if (formState.confirmModalLabels) {
      const {
        title,
        body,
        confirmButton,
        cancelButton
      } = formState.confirmModalLabels;
      return /*#__PURE__*/_react.default.createElement(_artifact_confirm_modal.ArtifactConfirmModal, {
        title: title,
        body: body,
        confirmButton: confirmButton,
        cancelButton: cancelButton,
        onSuccess: confirmModalOnSuccess,
        onCancel: () => setShowConfirmModal(false),
        "data-test-subj": "artifactConfirmModal",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 391,
          columnNumber: 11
        }
      });
    }
  }, [formState, confirmModalOnSuccess]);

  // If this form was opened from an endpoint insight, prepopulate the form with the insight data
  (0, _react.useEffect)(() => {
    var _location$state, _location$state$insig, _location$state2, _location$state2$insi;
    if ((_location$state = location.state) !== null && _location$state !== void 0 && (_location$state$insig = _location$state.insight) !== null && _location$state$insig !== void 0 && _location$state$insig.id && (_location$state2 = location.state) !== null && _location$state2 !== void 0 && (_location$state2$insi = _location$state2.insight) !== null && _location$state2$insi !== void 0 && _location$state2$insi.item) {
      setSourceInsight({
        id: location.state.insight.id,
        back_url: location.state.insight.back_url
      });
      setFormState({
        isValid: true,
        item: location.state.insight.item
      });
      location.state.insight = undefined;
    }
  }, [apiClient.listId, location.state, (_location$state3 = location.state) === null || _location$state3 === void 0 ? void 0 : _location$state3.insight]);

  // If we don't have the actual Artifact data yet for edit (in initialization phase - ex. came in with an
  // ID in the url that was not in the list), then retrieve it now
  (0, _react.useEffect)(() => {
    if (isEditFlow && !hasItemDataForEdit && !error && isInitializing && !isLoadingItemForEdit) {
      fetchItemForEdit().then(({
        data: editItemData
      }) => {
        if (editItemData && isMounted()) {
          setFormState(createFormInitialState(apiClient.listId, editItemData));
        }
      });
    }
  }, [apiClient.listId, error, fetchItemForEdit, isEditFlow, isInitializing, isLoadingItemForEdit, hasItemDataForEdit, isMounted]);

  // If we got an error while trying to retrieve the item for edit, then show a toast message
  (0, _react.useEffect)(() => {
    if (isEditFlow && error) {
      var _error$body;
      toasts.addWarning(labels.flyoutEditItemLoadFailure((error === null || error === void 0 ? void 0 : (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.message) || error.message));

      // Blank out the url params for id and show (will close out the flyout)
      setUrlParams({
        itemId: undefined,
        show: undefined
      });
    }
  }, [error, isEditFlow, labels, setUrlParams, toasts, urlParams.itemId]);
  const artifactFlyoutTitleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'artifactFlyoutTitle'
  });
  if (!isFlyoutOpened || error) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    size: size,
    onClose: handleFlyoutClose,
    "data-test-subj": dataTestSubj,
    "aria-labelledby": artifactFlyoutTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 457,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 463,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 464,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: artifactFlyoutTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 465,
      columnNumber: 13
    }
  }, isEditFlow ? labels.flyoutEditTitle : labels.flyoutCreateTitle))), !isInitializing && showExpiredLicenseBanner && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: labels.flyoutDowngradedLicenseTitle,
    color: "warning",
    iconType: "question",
    "data-test-subj": getTestId('expiredLicenseCallout'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 471,
      columnNumber: 11
    }
  }, labels.flyoutDowngradedLicenseInfo, ' ', labels.flyoutDowngradedLicenseDocsInfo(securitySolution)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 481,
      columnNumber: 9
    }
  }, isInitializing && /*#__PURE__*/_react.default.createElement(_management_page_loader.ManagementPageLoader, {
    "data-test-subj": getTestId('loader'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 482,
      columnNumber: 30
    }
  }), !isInitializing && /*#__PURE__*/_react.default.createElement(FormComponent, {
    onChange: handleFormComponentOnChange,
    disabled: isSubmittingData,
    item: formState.item,
    error: submitError !== null && submitError !== void 0 ? submitError : undefined,
    mode: formMode,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 485,
      columnNumber: 13
    }
  })), !isInitializing && /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 495,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 496,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 497,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": getTestId('cancelButton'),
    onClick: handleFlyoutClose,
    disabled: isSubmittingData,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 498,
      columnNumber: 17
    }
  }, labels.flyoutCancelButtonLabel)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 506,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": getTestId('submitButton'),
    fill: true,
    disabled: !formState.isValid || isSubmittingData,
    onClick: handleSubmitClick,
    isLoading: isSubmittingData,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 507,
      columnNumber: 17
    }
  }, isEditFlow ? labels.flyoutEditSubmitButtonLabel : labels.flyoutCreateSubmitButtonLabel)))), showConfirmModal && confirmModal);
});
ArtifactFlyout.displayName = 'ArtifactFlyout';