"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ArtifactEntryCardMinified = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _card_artifact_context = require("./components/card_artifact_context");
var _criteria_conditions = require("./components/criteria_conditions");
var _use_normalized_artifact = require("./hooks/use_normalized_artifact");
var _use_test_id_generator = require("../../hooks/use_test_id_generator");
var _translations = require("./components/translations");
var _description_field = require("./components/description_field");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/artifact_entry_card/artifact_entry_card_minified.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CardContainerPanel = (0, _styled.default)(_eui.EuiSplitPanel.Outer)`
  &.artifactEntryCardMinified + &.artifactEntryCardMinified {
    margin-top: ${({
  theme
}) => theme.euiTheme.size.l};
  }
`;
const CustomSplitInnerPanel = (0, _styled.default)(_eui.EuiSplitPanel.Inner)`
  background-color: ${({
  theme
}) => theme.euiTheme.colors.backgroundBasePrimary};
`;
/**
 * Display Artifact Items (ex. Trusted App, Event Filter, etc) as a minified card.
 * This component is a TS Generic that allows you to set what the Item type is
 */
const ArtifactEntryCardMinified = exports.ArtifactEntryCardMinified = /*#__PURE__*/(0, _react.memo)(({
  item,
  isSelected = false,
  onToggleSelectedArtifact,
  'data-test-subj': dataTestSubj,
  Decorator,
  ...commonProps
}) => {
  var _commonProps$classNam;
  const artifact = (0, _use_normalized_artifact.useNormalizedArtifact)(item);
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const [accordionTrigger, setAccordionTrigger] = (0, _react.useState)('closed');
  const handleOnToggleAccordion = (0, _react.useCallback)(() => {
    setAccordionTrigger(current => current === 'closed' ? 'open' : 'closed');
  }, []);
  const getAccordionTitle = (0, _react.useCallback)(() => accordionTrigger === 'open' ? 'Hide details' : 'Show details', [accordionTrigger]);
  const cardTitle = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(CustomSplitInnerPanel, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: artifact.name,
    "data-test-subj": `${artifact.name}_checkbox`,
    checked: isSelected,
    onChange: () => onToggleSelectedArtifact(!isSelected),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    "data-test-subj": getTestId('title'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 17
    }
  }, artifact.name))))), [artifact.name, getTestId, isSelected, onToggleSelectedArtifact]);
  return /*#__PURE__*/_react.default.createElement(CardContainerPanel, (0, _extends2.default)({}, commonProps, {
    "data-test-subj": dataTestSubj,
    className: `${(_commonProps$classNam = commonProps.className) !== null && _commonProps$classNam !== void 0 ? _commonProps$classNam : ''}  artifactEntryCardMinified`,
    id: artifact.name,
    hasShadow: false,
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_card_artifact_context.CardArtifactProvider, {
    item: item,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 9
    }
  }, cardTitle, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    paddingSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: false,
    hasShadow: false,
    paddingSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    "data-test-subj": getTestId('descriptionTitle'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 17
    }
  }, _translations.DESCRIPTION_LABEL)), /*#__PURE__*/_react.default.createElement(_description_field.DescriptionField, {
    "data-test-subj": getTestId('description'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 15
    }
  }, artifact.description)), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: false,
    hasShadow: false,
    paddingSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": getTestId('collapse'),
    color: "primary",
    size: "s",
    flush: "left",
    iconType: accordionTrigger === 'open' ? 'arrowUp' : 'arrowDown',
    iconSide: "right",
    iconSize: "m",
    onClick: handleOnToggleAccordion,
    css: {
      fontWeight: 400
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 15
    }
  }, getAccordionTitle()), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "showDetails",
    arrowDisplay: "none",
    forceState: accordionTrigger,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 15
    }
  }, Decorator && /*#__PURE__*/_react.default.createElement(Decorator, {
    item: item,
    "data-test-subj": getTestId('decorator'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 31
    }
  }), /*#__PURE__*/_react.default.createElement(_criteria_conditions.CriteriaConditions, {
    os: artifact.os,
    entries: artifact.entries,
    "data-test-subj": getTestId('criteriaConditions'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 17
    }
  }))))));
});
ArtifactEntryCardMinified.displayName = 'ArtifactEntryCardMinified';