"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFieldFromBrowserField = exports.TableTab = void 0;
var _react = _interopRequireWildcard(require("react"));
var _fp = require("lodash/fp");
var _memoizeOne = _interopRequireDefault(require("memoize-one"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _helpers = require("@kbn/response-ops-alerts-fields-browser/helpers");
var _test_ids = require("./test_ids");
var _source = require("../../../../common/containers/source");
var _use_selector = require("../../../../common/hooks/use_selector");
var _defaults = require("../../../../timelines/store/defaults");
var _store = require("../../../../timelines/store");
var _context = require("../../shared/context");
var _helpers2 = require("../../../../helpers");
var _use_basic_data_from_details_data = require("../../shared/hooks/use_basic_data_from_details_data");
var _table_tab_utils = require("../utils/table_tab_utils");
var _table_tab_setting_button = require("../components/table_tab_setting_button");
var _kibana = require("../../../../common/lib/kibana");
var _local_storage = require("../../shared/constants/local_storage");
var _table_tab_columns = require("../utils/table_tab_columns");
var _use_highlighted_fields = require("../../shared/hooks/use_highlighted_fields");
var _table_tab_tour = require("../components/table_tab_tour");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/document_details/right/tabs/table_tab.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const COUNT_PER_PAGE_OPTIONS = [25, 50, 100];
const PLACEHOLDER = _i18n.i18n.translate('xpack.securitySolution.flyout.table.filterPlaceholderLabel', {
  defaultMessage: 'Filter by field or value...'
});
const PIN_ACTION_CSS = (0, _react2.css)`
  .flyout_table__unPinAction {
    opacity: 1;
  }
  .flyout_table__pinAction {
    opacity: 0;
  }
  &:hover {
    .flyout_table__pinAction {
      opacity: 1;
    }
  }
`;
const DEFAULT_TABLE_TAB_STATE = {
  pinnedFields: [],
  showHighlightedFields: false,
  hideEmptyFields: false,
  hideAlertFields: false
};

/**
 * Defines the behavior of the search input that appears above the table of data
 */
const SEARCH_CONFIG = {
  box: {
    incremental: true,
    placeholder: PLACEHOLDER,
    schema: true,
    'data-test-subj': _test_ids.TABLE_TAB_SEARCH_INPUT_TEST_ID
  }
};

/**
 * Retrieve the correct field from the BrowserField
 */
const getFieldFromBrowserField = exports.getFieldFromBrowserField = (0, _memoizeOne.default)((field, browserFields) => {
  var _browserFields$catego, _browserFields$catego2;
  const category = (0, _helpers.getCategory)(field);
  return (_browserFields$catego = browserFields[category]) === null || _browserFields$catego === void 0 ? void 0 : (_browserFields$catego2 = _browserFields$catego.fields) === null || _browserFields$catego2 === void 0 ? void 0 : _browserFields$catego2[field];
}, (newArgs, lastArgs) => newArgs[0] === lastArgs[0]);

/**
 * Table view displayed in the document details expandable flyout right section Table tab
 */
const TableTab = exports.TableTab = /*#__PURE__*/(0, _react.memo)(() => {
  const smallFontSize = (0, _eui.useEuiFontSize)('xs').fontSize;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    services: {
      storage
    }
  } = (0, _kibana.useKibana)();
  const {
    browserFields,
    dataFormattedForFieldBrowser,
    scopeId,
    isRulePreview,
    eventId,
    investigationFields
  } = (0, _context.useDocumentDetailsContext)();
  const {
    ruleId,
    isAlert
  } = (0, _use_basic_data_from_details_data.useBasicDataFromDetailsData)(dataFormattedForFieldBrowser);
  const highlightedFieldsResult = (0, _use_highlighted_fields.useHighlightedFields)({
    dataFormattedForFieldBrowser,
    investigationFields
  });
  const highlightedFields = (0, _react.useMemo)(() => Object.keys(highlightedFieldsResult), [highlightedFieldsResult]);
  const [tableTabState, setTableTabState] = (0, _react.useState)(() => {
    const restoredTableTabState = storage.get(_local_storage.FLYOUT_STORAGE_KEYS.TABLE_TAB_STATE);
    if (restoredTableTabState != null) {
      return restoredTableTabState;
    }
    return DEFAULT_TABLE_TAB_STATE;
  });
  (0, _react.useEffect)(() => {
    storage.set(_local_storage.FLYOUT_STORAGE_KEYS.TABLE_TAB_STATE, tableTabState);
  }, [tableTabState, storage]);
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const renderToolsRight = (0, _react.useCallback)(() => [/*#__PURE__*/_react.default.createElement(_table_tab_setting_button.TableTabSettingButton, {
    tableTabState: tableTabState,
    setTableTabState: setTableTabState,
    isPopoverOpen: isPopoverOpen,
    setIsPopoverOpen: setIsPopoverOpen,
    isAlert: isAlert,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 7
    }
  })], [tableTabState, setTableTabState, isPopoverOpen, setIsPopoverOpen, isAlert]);
  const [pagination, setPagination] = (0, _react.useState)({
    pageIndex: 0
  });
  const onTableChange = (0, _react.useCallback)(({
    page: {
      index
    }
  }) => {
    setPagination({
      pageIndex: index
    });
  }, []);
  const paginationSettings = (0, _react.useMemo)(() => ({
    ...pagination,
    pageSizeOptions: COUNT_PER_PAGE_OPTIONS
  }), [pagination]);
  const getScope = (0, _react.useMemo)(() => {
    if ((0, _helpers2.isTimelineScope)(scopeId)) {
      return _store.timelineSelectors.getTimelineByIdSelector();
    } else if ((0, _helpers2.isInTableScope)(scopeId)) {
      return _securitysolutionDataTable.dataTableSelectors.getTableByIdSelector();
    }
  }, [scopeId]);
  const defaults = (0, _react.useMemo)(() => (0, _helpers2.isTimelineScope)(scopeId) ? _defaults.timelineDefaults : _securitysolutionDataTable.tableDefaults, [scopeId]);
  const columnHeaders = (0, _use_selector.useDeepEqualSelector)(state => {
    var _ref;
    const {
      columns
    } = (_ref = getScope && getScope(state, scopeId)) !== null && _ref !== void 0 ? _ref : defaults;
    return columns;
  });
  const fieldsByName = (0, _react.useMemo)(() => (0, _source.getAllFieldsByName)(browserFields), [browserFields]);
  const {
    pinnedFields
  } = (0, _react.useMemo)(() => tableTabState, [tableTabState]);
  const onTogglePinned = (0, _react.useCallback)((field, action) => {
    if (action === 'pin') {
      setTableTabState({
        ...tableTabState,
        pinnedFields: [...pinnedFields, field]
      });
    } else if (action === 'unpin') {
      setTableTabState({
        ...tableTabState,
        pinnedFields: pinnedFields.filter(f => f !== field)
      });
    }
  }, [pinnedFields, tableTabState, setTableTabState]);
  const items = (0, _react.useMemo)(() => (0, _table_tab_utils.getTableItems)({
    dataFormattedForFieldBrowser,
    fieldsByName,
    highlightedFields,
    tableTabState
  }), [dataFormattedForFieldBrowser, highlightedFields, tableTabState, fieldsByName]);
  const getLinkValue = (0, _react.useCallback)(field => {
    const columnHeader = columnHeaders.find(col => col.id === field);
    if (!columnHeader || !columnHeader.linkField) {
      return null;
    }
    const linkFieldData = (dataFormattedForFieldBrowser !== null && dataFormattedForFieldBrowser !== void 0 ? dataFormattedForFieldBrowser : []).find(d => d.field === columnHeader.linkField);
    const linkFieldValue = (0, _fp.getOr)(null, 'originalValue', linkFieldData);
    return Array.isArray(linkFieldValue) ? linkFieldValue[0] : linkFieldValue;
  }, [dataFormattedForFieldBrowser, columnHeaders]);

  // forces the rows of the table to render smaller fonts
  const onSetRowProps = (0, _react.useCallback)(({
    field
  }) => ({
    className: 'flyout-table-row-small-font',
    'data-test-subj': `flyout-table-row-${field}`,
    ...(highlightedFields.includes(field) && {
      style: {
        backgroundColor: euiTheme.colors.backgroundBaseWarning
      }
    }),
    css: PIN_ACTION_CSS
  }), [highlightedFields, euiTheme.colors]);
  const columns = (0, _react.useMemo)(() => (0, _table_tab_columns.getTableTabColumns)({
    browserFields,
    eventId,
    scopeId,
    getLinkValue,
    ruleId,
    isRulePreview,
    onTogglePinned
  }), [browserFields, eventId, scopeId, getLinkValue, ruleId, isRulePreview, onTogglePinned]);
  const search = (0, _react.useMemo)(() => {
    return {
      ...SEARCH_CONFIG,
      toolsRight: renderToolsRight()
    };
  }, [renderToolsRight]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_table_tab_tour.TableTabTour, {
    setIsPopoverOpen: setIsPopoverOpen,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 271,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    items: items,
    itemId: "field",
    columns: columns,
    onTableChange: onTableChange,
    pagination: paginationSettings,
    rowProps: onSetRowProps,
    search: search,
    sorting: false,
    "data-test-subj": _test_ids.TABLE_TAB_CONTENT_TEST_ID,
    css: (0, _react2.css)`
          .euiTableRow {
            font-size: ${smallFontSize};
          }
        `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 272,
      columnNumber: 7
    }
  }));
});
TableTab.displayName = 'TableTab';