"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertStatus = void 0;
var _eui = require("@elastic/eui");
var _userProfileComponents = require("@kbn/user-profile-components");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _test_ids = require("./test_ids");
var _use_bulk_get_user_profiles = require("../../../../common/components/user_profiles/use_bulk_get_user_profiles");
var _formatted_date = require("../../../../common/components/formatted_date");
var _context = require("../../shared/context");
var _utils = require("../../shared/utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/document_details/right/components/alert_status.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Displays info about who last updated the alert's workflow status and when.
 */
const AlertStatus = exports.AlertStatus = /*#__PURE__*/(0, _react.memo)(() => {
  var _result$data, _result$data$;
  const {
    getFieldsData
  } = (0, _context.useDocumentDetailsContext)();
  const statusUpdatedBy = getFieldsData('kibana.alert.workflow_user');
  const statusUpdatedAt = (0, _utils.getField)(getFieldsData('kibana.alert.workflow_status_updated_at'));
  const result = (0, _use_bulk_get_user_profiles.useBulkGetUserProfiles)({
    uids: new Set(statusUpdatedBy)
  });
  const user = (_result$data = result.data) === null || _result$data === void 0 ? void 0 : (_result$data$ = _result$data[0]) === null || _result$data$ === void 0 ? void 0 : _result$data$.user;
  const lastStatusChange = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, user && statusUpdatedAt && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.right.about.status.statusHistoryDetails",
    defaultMessage: "Alert status updated by {user} on {date}",
    values: {
      user: (0, _userProfileComponents.getUserDisplayName)(user),
      date: /*#__PURE__*/_react.default.createElement(_formatted_date.PreferenceFormattedDate, {
        value: new Date(statusUpdatedAt),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 38,
          columnNumber: 21
        }
      })
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 11
    }
  })), [statusUpdatedAt, user]);
  if (!statusUpdatedBy || !statusUpdatedAt || result.isLoading || user == null) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": _test_ids.WORKFLOW_STATUS_TITLE_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.right.about.status.statusHistoryTitle",
    defaultMessage: "Last alert status change",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": _test_ids.WORKFLOW_STATUS_DETAILS_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 7
    }
  }, lastStatusChange));
});
AlertStatus.displayName = 'AlertStatus';