"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAlertReasonPanelContext = exports.AlertReasonPanelProvider = exports.AlertReasonPanelContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _use_event_details = require("../shared/hooks/use_event_details");
var _flyout_error = require("../../shared/components/flyout_error");
var _flyout_loading = require("../../shared/components/flyout_loading");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/document_details/alert_reason/context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AlertReasonPanelContext = exports.AlertReasonPanelContext = /*#__PURE__*/(0, _react.createContext)(undefined);
const AlertReasonPanelProvider = exports.AlertReasonPanelProvider = /*#__PURE__*/(0, _react.memo)(({
  id,
  indexName,
  scopeId,
  children
}) => {
  const {
    dataAsNestedObject,
    loading
  } = (0, _use_event_details.useEventDetails)({
    eventId: id,
    indexName
  });
  const contextValue = (0, _react.useMemo)(() => id && indexName && scopeId && dataAsNestedObject ? {
    eventId: id,
    indexName,
    scopeId,
    dataAsNestedObject
  } : undefined, [id, indexName, scopeId, dataAsNestedObject]);
  if (loading) {
    return /*#__PURE__*/_react.default.createElement(_flyout_loading.FlyoutLoading, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 14
      }
    });
  }
  if (!contextValue) {
    return /*#__PURE__*/_react.default.createElement(_flyout_error.FlyoutError, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 14
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(AlertReasonPanelContext.Provider, {
    value: contextValue,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 7
    }
  }, children);
});
AlertReasonPanelProvider.displayName = 'AlertReasonPanelProvider';
const useAlertReasonPanelContext = () => {
  const contextValue = (0, _react.useContext)(AlertReasonPanelContext);
  if (!contextValue) {
    throw new Error('AlertReasonPanelContext can only be used within AlertReasonPanelContext provider');
  }
  return contextValue;
};
exports.useAlertReasonPanelContext = useAlertReasonPanelContext;