"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NetworkContainer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _use_ml_capabilities = require("../../../common/components/ml/hooks/use_ml_capabilities");
var _has_ml_user_permissions = require("../../../../common/machine_learning/has_ml_user_permissions");
var _details = require("./details");
var _network = require("./network");
var _navigation = require("./navigation");
var _types = require("./navigation/types");
var _ml_network_conditional_container = require("../../../common/components/ml/conditional_links/ml_network_conditional_container");
var _constants = require("../../../../common/constants");
var _search_strategy = require("../../../../common/search_strategy");
var _constants2 = require("./constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/explore/network/pages/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getPathWithFlowType = (detailName, flowTarget) => `${_constants.NETWORK_PATH}/ip/${detailName}/${flowTarget || _search_strategy.FlowTargetSourceDest.source}/${_types.NetworkRouteType.flows}`;
const NetworkContainerComponent = () => {
  const capabilities = (0, _use_ml_capabilities.useMlCapabilities)();
  const capabilitiesFetched = capabilities.capabilitiesFetched;
  const userHasMlUserPermissions = (0, _react.useMemo)(() => (0, _has_ml_user_permissions.hasMlUserPermissions)(capabilities), [capabilities]);
  const networkRoutePath = (0, _react.useMemo)(() => (0, _navigation.getNetworkRoutePath)(capabilitiesFetched, userHasMlUserPermissions), [capabilitiesFetched, userHasMlUserPermissions]);
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    strict: true,
    path: _constants.NETWORK_PATH,
    render: ({
      location: {
        search = ''
      }
    }) => /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      to: {
        pathname: `${_constants.NETWORK_PATH}/${_types.NetworkRouteType.events}`,
        search
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 52,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${_constants.NETWORK_PATH}/ml-network`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_ml_network_conditional_container.MlNetworkConditionalContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    strict: true,
    path: networkRoutePath,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_network.Network, {
    capabilitiesFetched: capabilities.capabilitiesFetched,
    hasMlUserPermissions: userHasMlUserPermissions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants2.NETWORK_DETAILS_TAB_PATH,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_details.NetworkDetails, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${_constants2.NETWORK_DETAILS_PAGE_PATH}/:flowTarget(${_constants2.FLOW_TARGET_PARAM})?`,
    render: ({
      match: {
        params: {
          detailName,
          flowTarget
        }
      },
      location: {
        search = ''
      }
    }) => /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      to: {
        pathname: getPathWithFlowType(detailName, flowTarget),
        search
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: {
      pathname: _constants.NETWORK_PATH
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 9
    }
  })));
};
const NetworkContainer = exports.NetworkContainer = /*#__PURE__*/_react.default.memo(NetworkContainerComponent);