"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IpOverview = void 0;
var _uiTheme = require("@kbn/ui-theme");
var _react = _interopRequireDefault(require("react"));
var _reactKibanaContextTheme = require("@kbn/react-kibana-context-theme");
var _empty_value = require("../../../../common/components/empty_value");
var _field_renderers = require("../../../../timelines/components/field_renderers/field_renderers");
var _first_last_seen = require("../../../../common/components/first_last_seen/first_last_seen");
var i18n = _interopRequireWildcard(require("./translations"));
var _page = require("../../../../common/components/page");
var _loader = require("../../../../common/components/loader");
var _anomaly_scores = require("../../../../common/components/ml/score/anomaly_scores");
var _use_ml_capabilities = require("../../../../common/components/ml/hooks/use_ml_capabilities");
var _has_ml_user_permissions = require("../../../../../common/machine_learning/has_ml_user_permissions");
var _inspect = require("../../../../common/components/inspect");
var _overview_description_list = require("../../../../common/components/overview_description_list");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/explore/network/components/details/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const IpOverview = exports.IpOverview = /*#__PURE__*/_react.default.memo(({
  contextID,
  id,
  ip,
  data,
  isInDetailsSidePanel = false,
  // Rather than duplicate the component, alter the structure based on it's location
  loading,
  flowTarget,
  startDate,
  endDate,
  isLoadingAnomaliesData,
  anomaliesData,
  narrowDateRange,
  scopeId,
  indexPatterns,
  jobNameById,
  isFlyoutOpen = false
}) => {
  const capabilities = (0, _use_ml_capabilities.useMlCapabilities)();
  const userPermissions = (0, _has_ml_user_permissions.hasMlUserPermissions)(capabilities);
  const darkMode = (0, _reactKibanaContextTheme.useKibanaIsDarkMode)();
  const typeData = data[flowTarget];
  const column = [{
    title: i18n.LOCATION,
    description: (0, _field_renderers.locationRenderer)([`${flowTarget}.geo.city_name`, `${flowTarget}.geo.region_name`], data, contextID)
  }, {
    title: i18n.AUTONOMOUS_SYSTEM,
    description: typeData ? (0, _field_renderers.autonomousSystemRenderer)(typeData.autonomousSystem, flowTarget, contextID) : (0, _empty_value.getEmptyTagValue)()
  }];
  const firstColumn = userPermissions ? [...column, {
    title: i18n.MAX_ANOMALY_SCORE_BY_JOB,
    description: /*#__PURE__*/_react.default.createElement(_anomaly_scores.AnomalyScores, {
      anomalies: anomaliesData,
      startDate: startDate,
      endDate: endDate,
      isLoading: isLoadingAnomaliesData,
      narrowDateRange: narrowDateRange,
      jobNameById: jobNameById,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 109,
        columnNumber: 15
      }
    })
  }] : column;
  const descriptionLists = [firstColumn, [{
    title: i18n.FIRST_SEEN,
    description: /*#__PURE__*/_react.default.createElement(_first_last_seen.FirstLastSeen, {
      indexPatterns: indexPatterns,
      field: `${flowTarget}.ip`,
      value: ip,
      type: _first_last_seen.FirstLastSeenType.FIRST_SEEN,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 13
      }
    })
  }, {
    title: i18n.LAST_SEEN,
    description: /*#__PURE__*/_react.default.createElement(_first_last_seen.FirstLastSeen, {
      indexPatterns: indexPatterns,
      field: `${flowTarget}.ip`,
      value: ip,
      type: _first_last_seen.FirstLastSeenType.LAST_SEEN,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 139,
        columnNumber: 13
      }
    })
  }], [{
    title: i18n.HOST_ID,
    description: typeData && data.host ? (0, _field_renderers.hostIdRenderer)({
      host: data.host,
      ipFilter: ip,
      contextID,
      scopeId,
      isFlyoutOpen
    }) : (0, _empty_value.getEmptyTagValue)()
  }, {
    title: i18n.HOST_NAME,
    description: typeData && data.host ? (0, _field_renderers.hostNameRenderer)({
      scopeId,
      host: data.host,
      ipFilter: ip,
      contextID,
      isFlyoutOpen
    }) : (0, _empty_value.getEmptyTagValue)()
  }], [{
    title: i18n.WHOIS,
    description: (0, _field_renderers.whoisRenderer)(ip)
  }, {
    title: i18n.REPUTATION,
    description: (0, _field_renderers.reputationRenderer)(ip)
  }]];
  return /*#__PURE__*/_react.default.createElement(_inspect.InspectButtonContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_page.OverviewWrapper, {
    direction: isInDetailsSidePanel ? 'column' : 'row',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 9
    }
  }, !isInDetailsSidePanel && /*#__PURE__*/_react.default.createElement(_inspect.InspectButton, {
    queryId: id,
    title: i18n.INSPECT_TITLE,
    inspectIndex: 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 13
    }
  }), descriptionLists.map((descriptionList, index) => /*#__PURE__*/_react.default.createElement(_overview_description_list.OverviewDescriptionList, {
    descriptionList: descriptionList,
    key: index,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 13
    }
  })), loading && /*#__PURE__*/_react.default.createElement(_loader.Loader, {
    overlay: true,
    overlayBackground: darkMode ? _uiTheme.euiDarkVars.euiPageBackgroundColor : _uiTheme.euiLightVars.euiPageBackgroundColor,
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 13
    }
  })));
});
IpOverview.displayName = 'IpOverview';