"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEndpointExceptionsCapability = void 0;
var _react = require("react");
var _use_experimental_features = require("../../../common/hooks/use_experimental_features");
var _helper_hooks = require("../../../helper_hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useEndpointExceptionsCapability = capability => {
  const isEndpointSpaceAwarenessEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('endpointManagementSpaceAwarenessEnabled');
  const canWriteGlobalArtifacts = (0, _helper_hooks.useHasSecurityCapability)('writeGlobalArtifacts');
  const hasCapability = (0, _helper_hooks.useHasSecurityCapability)(capability);
  return (0, _react.useMemo)(() => {
    if (!isEndpointSpaceAwarenessEnabled || capability === 'showEndpointExceptions') {
      return hasCapability;
    }
    return hasCapability && canWriteGlobalArtifacts;
  }, [canWriteGlobalArtifacts, capability, hasCapability, isEndpointSpaceAwarenessEnabled]);
};
exports.useEndpointExceptionsCapability = useEndpointExceptionsCapability;