"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFillGapMutation = exports.FILL_GAP_BY_ID_MUTATION_KEY = void 0;
var _reactQuery = require("@tanstack/react-query");
var _use_find_gaps_for_rule = require("./use_find_gaps_for_rule");
var _use_find_backfills_for_rules = require("./use_find_backfills_for_rules");
var _use_get_rule_ids_with_gaps = require("./use_get_rule_ids_with_gaps");
var _api = require("../api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FILL_GAP_BY_ID_MUTATION_KEY = exports.FILL_GAP_BY_ID_MUTATION_KEY = ['POST', 'FILL_GAP_BY_ID_MUTATION_KEY'];
const useFillGapMutation = options => {
  const invalidateFindGapsQuery = (0, _use_find_gaps_for_rule.useInvalidateFindGapsQuery)();
  const invalidateFindBackfillsQuery = (0, _use_find_backfills_for_rules.useInvalidateFindBackfillQuery)();
  const invalidateGetRuleIdsWithGapsQuery = (0, _use_get_rule_ids_with_gaps.useInvalidateGetRuleIdsWithGapsQuery)();
  return (0, _reactQuery.useMutation)(fillGapsOptions => (0, _api.fillGapByIdForRule)(fillGapsOptions), {
    ...options,
    onSettled: (...args) => {
      invalidateFindGapsQuery();
      invalidateFindBackfillsQuery();
      invalidateGetRuleIdsWithGapsQuery();
      if (options !== null && options !== void 0 && options.onSettled) {
        options.onSettled(...args);
      }
    },
    mutationKey: FILL_GAP_BY_ID_MUTATION_KEY
  });
};
exports.useFillGapMutation = useFillGapMutation;