"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRuleDetailsContext = exports.RuleDetailsContextProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _constants = require("../../../../../common/constants");
var _invariant = require("../../../../../common/utils/invariant");
var _kibana = require("../../../../common/lib/kibana");
var _use_rule_details_tabs = require("./use_rule_details_tabs");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_details_ui/pages/rule_details/rule_details_context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// @ts-expect-error unused constant
const DEFAULT_STATE = {
  superDatePicker: {
    recentlyUsedRanges: [],
    refreshInterval: 1000,
    isPaused: true,
    start: 'now-24hr',
    end: 'now'
  },
  queryText: '',
  statusFilters: [],
  runTypeFilters: [],
  showMetricColumns: false,
  showSourceEventTimeRange: false,
  pagination: {
    pageIndex: 1,
    pageSize: 5
  },
  sort: {
    sortField: 'timestamp',
    sortDirection: 'desc'
  }
};
const RuleDetailsContext = /*#__PURE__*/(0, _react.createContext)(null);
const RuleDetailsContextProvider = ({
  children
}) => {
  var _storage$get, _storage$get2;
  const {
    storage
  } = (0, _kibana.useKibana)().services;

  // Execution Log Table tab
  // // SuperDatePicker State
  const [recentlyUsedRanges, setRecentlyUsedRanges] = (0, _react.useState)([]);
  const [refreshInterval, setRefreshInterval] = (0, _react.useState)(1000);
  const [isPaused, setIsPaused] = (0, _react.useState)(true);
  const [start, setStart] = (0, _react.useState)('now-24h');
  const [end, setEnd] = (0, _react.useState)('now');
  // Searchbar/Filter/Settings state
  const [queryText, setQueryText] = (0, _react.useState)('');
  const [statusFilters, setStatusFilters] = (0, _react.useState)([]);
  const [runTypeFilters, setRunTypeFilters] = (0, _react.useState)([]);
  const [showMetricColumns, setShowMetricColumns] = (0, _react.useState)((_storage$get = storage.get(_constants.RULE_DETAILS_EXECUTION_LOG_TABLE_SHOW_METRIC_COLUMNS_STORAGE_KEY)) !== null && _storage$get !== void 0 ? _storage$get : false);
  const [showSourceEventTimeRange, setShowSourceEventTimeRange] = (0, _react.useState)((_storage$get2 = storage.get(_constants.RULE_DETAILS_EXECUTION_LOG_TABLE_SHOW_SOURCE_EVENT_TIME_RANGE_STORAGE_KEY)) !== null && _storage$get2 !== void 0 ? _storage$get2 : false);
  // Pagination state
  const [pageIndex, setPageIndex] = (0, _react.useState)(1);
  const [pageSize, setPageSize] = (0, _react.useState)(5);
  const [sortField, setSortField] = (0, _react.useState)('timestamp');
  const [sortDirection, setSortDirection] = (0, _react.useState)('desc');
  // // End Execution Log Table tab

  const providerValue = (0, _react.useMemo)(() => ({
    [_use_rule_details_tabs.RuleDetailTabs.executionResults]: {
      state: {
        superDatePicker: {
          recentlyUsedRanges,
          refreshInterval,
          isPaused,
          start,
          end
        },
        queryText,
        statusFilters,
        runTypeFilters,
        showMetricColumns,
        showSourceEventTimeRange,
        pagination: {
          pageIndex,
          pageSize
        },
        sort: {
          sortField,
          sortDirection
        }
      },
      actions: {
        setEnd,
        setIsPaused,
        setPageIndex,
        setPageSize,
        setQueryText,
        setRecentlyUsedRanges,
        setRefreshInterval,
        setShowMetricColumns,
        setSortDirection,
        setSortField,
        setStart,
        setStatusFilters,
        setRunTypeFilters,
        setShowSourceEventTimeRange
      }
    }
  }), [end, isPaused, pageIndex, pageSize, queryText, recentlyUsedRanges, refreshInterval, showMetricColumns, sortDirection, sortField, start, statusFilters, runTypeFilters, showSourceEventTimeRange]);
  return /*#__PURE__*/_react.default.createElement(RuleDetailsContext.Provider, {
    value: providerValue,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 5
    }
  }, children);
};
exports.RuleDetailsContextProvider = RuleDetailsContextProvider;
const useRuleDetailsContext = () => {
  const ruleDetailsContext = (0, _react.useContext)(RuleDetailsContext);
  (0, _invariant.invariant)(ruleDetailsContext, 'useRuleDetailsContext should be used inside RuleDetailsContextProvider');
  return ruleDetailsContext;
};
exports.useRuleDetailsContext = useRuleDetailsContext;