"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.THRESHOLD_TYPE_TITLE = exports.THRESHOLD_TYPE_DESCRIPTION = exports.THREAT_MATCH_TYPE_TITLE = exports.THREAT_MATCH_TYPE_DESCRIPTION = exports.QUERY_TYPE_TITLE = exports.QUERY_TYPE_DESCRIPTION = exports.NEW_TERMS_TYPE_TITLE = exports.NEW_TERMS_TYPE_DESCRIPTION = exports.ML_TYPE_TITLE = exports.ML_TYPE_DESCRIPTION = exports.ESQL_TYPE_TITLE = exports.ESQL_TYPE_DESCRIPTION = exports.EQL_TYPE_TITLE = exports.EQL_TYPE_DESCRIPTION = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EQL_TYPE_TITLE = exports.EQL_TYPE_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.ruleTypeField.eqlTypeTitle', {
  defaultMessage: 'Event Correlation'
});
const EQL_TYPE_DESCRIPTION = exports.EQL_TYPE_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.ruleTypeField.eqlTypeDescription', {
  defaultMessage: 'Use Event Query Language (EQL) to match events, generate sequences, and stack data'
});
const ESQL_TYPE_TITLE = exports.ESQL_TYPE_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.ruleTypeField.esqlTypeTitle', {
  defaultMessage: 'ES|QL'
});
const ESQL_TYPE_DESCRIPTION = exports.ESQL_TYPE_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.ruleTypeField.esqlTypeDescription', {
  defaultMessage: 'Use Elasticsearch Query Language (ES|QL) to find events and aggregate search results.'
});
const QUERY_TYPE_TITLE = exports.QUERY_TYPE_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.ruleTypeField.queryTypeTitle', {
  defaultMessage: 'Custom query'
});
const QUERY_TYPE_DESCRIPTION = exports.QUERY_TYPE_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.ruleTypeField.queryTypeDescription', {
  defaultMessage: 'Use KQL or Lucene to detect issues across indices.'
});
const ML_TYPE_TITLE = exports.ML_TYPE_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.ruleTypeField.mlTypeTitle', {
  defaultMessage: 'Machine Learning'
});
const ML_TYPE_DESCRIPTION = exports.ML_TYPE_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.ruleTypeField.mlTypeDescription', {
  defaultMessage: 'Select ML job to detect anomalous activity.'
});
const THRESHOLD_TYPE_TITLE = exports.THRESHOLD_TYPE_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.ruleTypeField.thresholdTypeTitle', {
  defaultMessage: 'Threshold'
});
const THRESHOLD_TYPE_DESCRIPTION = exports.THRESHOLD_TYPE_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.ruleTypeField.thresholdTypeDescription', {
  defaultMessage: 'Aggregate query results to detect when number of matches exceeds threshold.'
});
const THREAT_MATCH_TYPE_TITLE = exports.THREAT_MATCH_TYPE_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.ruleTypeField.threatMatchTitle', {
  defaultMessage: 'Indicator Match'
});
const THREAT_MATCH_TYPE_DESCRIPTION = exports.THREAT_MATCH_TYPE_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.ruleTypeField.threatMatchDescription', {
  defaultMessage: 'Use indicators from intelligence sources to detect matching events and alerts.'
});
const NEW_TERMS_TYPE_TITLE = exports.NEW_TERMS_TYPE_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.ruleTypeField.newTermsTitle', {
  defaultMessage: 'New Terms'
});
const NEW_TERMS_TYPE_DESCRIPTION = exports.NEW_TERMS_TYPE_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.ruleTypeField.newTermsDescription', {
  defaultMessage: 'Find documents with values appearing for the first time.'
});