"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LoggedRequests = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var i18n = _interopRequireWildcard(require("./translations"));
var _optimized_accordion = require("./optimized_accordion");
var _logged_requests_item = require("./logged_requests_item");
var _use_accordion_styling = require("./use_accordion_styling");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_creation_ui/components/rule_preview/logged_requests.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LoggedRequestsComponent = ({
  logs,
  ruleType
}) => {
  const cssStyles = (0, _use_accordion_styling.useAccordionStyling)();
  const AccordionContent = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 9
    }
  }), logs.map(log => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
    key: log.startedAt,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_logged_requests_item.LoggedRequestsItem, (0, _extends2.default)({}, log, {
    ruleType: ruleType,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 13
    }
  }))))), [logs, ruleType]);
  if (logs.length === 0) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_optimized_accordion.OptimizedAccordion, {
    id: "preview-logged-requests-accordion",
    "data-test-subj": "preview-logged-requests-accordion",
    buttonContent: i18n.LOGGED_REQUESTS_ACCORDION_BUTTON,
    borders: "horizontal",
    css: (0, _react2.css)`
          ${cssStyles}
        `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 7
    }
  }, AccordionContent));
};
const LoggedRequests = exports.LoggedRequests = /*#__PURE__*/_react.default.memo(LoggedRequestsComponent);
LoggedRequests.displayName = 'LoggedRequests';