"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.normalizeTimeRange = void 0;
var _default_date_settings = require("./default_date_settings");
var _maybe_date = require("../components/formatted_date/maybe_date");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const normalizeTimeRange = (dateRange, uiSettings = true) => {
  const maybeTo = (0, _maybe_date.getMaybeDate)(dateRange.to);
  const maybeFrom = (0, _maybe_date.getMaybeDate)(dateRange.from);
  const {
    to: benchTo,
    from: benchFrom
  } = (0, _default_date_settings.getTimeRangeSettings)(uiSettings);
  const to = maybeTo.isValid() ? maybeTo.toISOString() : benchTo;
  const from = maybeFrom.isValid() ? maybeFrom.toISOString() : benchFrom;
  return {
    ...dateRange,
    to,
    from
  };
};
exports.normalizeTimeRange = normalizeTimeRange;