"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.INTEGRATION_TABS = void 0;
var _constants = require("../constants");
var _types = require("../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INTEGRATION_TABS = exports.INTEGRATION_TABS = [{
  category: '',
  iconType: 'starFilled',
  id: _types.IntegrationTabId.recommended,
  label: 'Recommended',
  overflow: 'hidden',
  showSearchTools: false,
  // Fleet has a default sorting for integrations by category that Security Solution does not want to apply
  // so we need to disable the sorting for the recommended tab to allow static ordering according to the featuredCardIds
  sortByFeaturedIntegrations: false,
  featuredCardIds: ['epr:aws', 'epr:gcp', 'epr:azure', 'epr:endpoint', 'epr:crowdstrike', 'epr:wiz', 'epr:network_traffic', 'epr:osquery_manager'],
  height: `${_constants.INTEGRATION_CARD_HEIGHT * 3.5}px`
}, {
  category: 'security',
  id: _types.IntegrationTabId.network,
  label: 'Network',
  subCategory: 'network',
  showSearchTools: true,
  sortByFeaturedIntegrations: true
}, {
  category: 'security',
  id: _types.IntegrationTabId.user,
  label: 'User',
  subCategory: 'iam',
  showSearchTools: true,
  sortByFeaturedIntegrations: true
}, {
  category: 'security',
  id: _types.IntegrationTabId.endpoint,
  label: 'Endpoint',
  subCategory: 'edr_xdr',
  showSearchTools: true,
  sortByFeaturedIntegrations: true
}, {
  category: 'security',
  id: _types.IntegrationTabId.cloud,
  label: 'Cloud',
  subCategory: 'cloudsecurity_cdr',
  showSearchTools: true,
  sortByFeaturedIntegrations: true
}, {
  category: 'security',
  id: _types.IntegrationTabId.threatIntel,
  label: 'Threat Intel',
  subCategory: 'threat_intel',
  showSearchTools: true,
  sortByFeaturedIntegrations: true
}, {
  category: '',
  id: _types.IntegrationTabId.all,
  label: 'All',
  showSearchTools: true,
  sortByFeaturedIntegrations: true
}];