"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "URL_PARAM_KEY", {
  enumerable: true,
  get: function () {
    return _constants.URL_PARAM_KEY;
  }
});
exports.useUrlState = void 0;
var _global_query_string = require("../utils/global_query_string");
var _use_init_search_bar_url_params = require("./search_bar/use_init_search_bar_url_params");
var _use_init_timerange_url_params = require("./search_bar/use_init_timerange_url_params");
var _use_update_timerange_on_page_change = require("./search_bar/use_update_timerange_on_page_change");
var _use_init_timeline_url_param = require("./timeline/use_init_timeline_url_param");
var _use_sync_timeline_url_param = require("./timeline/use_sync_timeline_url_param");
var _use_query_timeline_by_id_on_url_change = require("./timeline/use_query_timeline_by_id_on_url_change");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useUrlState = () => {
  (0, _global_query_string.useSyncGlobalQueryString)();
  (0, _use_init_search_bar_url_params.useInitSearchBarFromUrlParams)();
  (0, _use_init_timeline_url_param.useInitTimelineFromUrlParam)();
  (0, _use_sync_timeline_url_param.useSyncTimelineUrlParam)();
  (0, _use_query_timeline_by_id_on_url_change.useQueryTimelineByIdOnUrlChange)();
  (0, _use_init_timerange_url_params.useInitTimerangeFromUrlParam)();
  (0, _use_update_timerange_on_page_change.useUpdateTimerangeOnPageChange)();
};
exports.useUrlState = useUrlState;