"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCallOutStorage = void 0;
var _fp = require("lodash/fp");
var _react = require("react");
var _useMap = _interopRequireDefault(require("react-use/lib/useMap"));
var _use_messages_storage = require("../../containers/local_storage/use_messages_storage");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCallOutStorage = (messages, namespace = 'common') => {
  const {
    getMessages,
    addMessage
  } = (0, _use_messages_storage.useMessagesStorage)();
  const [visibilityState, setVisibilityState] = (0, _useMap.default)({});
  const dismissedMessagesKey = getDismissedMessagesStorageKey(namespace);
  const getVisibleMessageIds = (0, _react.useCallback)(() => {
    return Object.entries(visibilityState).filter(([messageId, isVisible]) => isVisible).map(([messageId, isVisible]) => messageId);
  }, [visibilityState]);
  const isVisible = (0, _react.useCallback)(message => {
    var _visibilityState$mess;
    return (_visibilityState$mess = visibilityState[message.id]) !== null && _visibilityState$mess !== void 0 ? _visibilityState$mess : false;
  }, [visibilityState]);
  const dismiss = (0, _react.useCallback)(message => {
    const {
      id,
      type
    } = message;

    // Remember dismissal in memory.
    setVisibilityState.set(id, false);

    // Remember dismissal in local storage for primary and success messages.
    // NOTE: danger and warning ones are not stored!
    if (type === 'primary' || type === 'success') {
      addMessage(dismissedMessagesKey, id);
    }
  }, [setVisibilityState, addMessage, dismissedMessagesKey]);
  const populateVisibilityState = (0, _react.useCallback)(ids => {
    const idsDismissed = getMessages(dismissedMessagesKey);
    const idsToShow = (0, _fp.difference)(ids, idsDismissed);
    const idsToHide = (0, _fp.intersection)(ids, idsDismissed);
    setVisibilityState.setAll({
      ...createVisibilityState(idsToShow, true),
      ...createVisibilityState(idsToHide, false)
    });
  }, [getMessages, dismissedMessagesKey, setVisibilityState]);
  (0, _react.useEffect)(() => {
    const idsFromProps = messages.map(m => m.id);
    const idsFromState = Object.keys(visibilityState);
    if (!(0, _fp.isEqual)(idsFromProps, idsFromState)) {
      populateVisibilityState(idsFromProps);
    }
  }, [messages, visibilityState, populateVisibilityState]);
  return {
    getVisibleMessageIds,
    isVisible,
    dismiss
  };
};
exports.useCallOutStorage = useCallOutStorage;
const getDismissedMessagesStorageKey = namespace => `kibana.securitySolution.${namespace}.callouts.dismissed`;
const createVisibilityState = (messageIds, isVisible) => mapToObject(messageIds, _fp.identity, () => isVisible);
const mapToObject = (array, getKey, getValue) => {
  const kvPairs = array.map(el => [getKey(el), getValue(el)]);
  return (0, _fp.fromPairs)(kvPairs);
};