"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCreateAttackDiscoverySchedule = exports.CREATE_ATTACK_DISCOVERY_SCHEDULE_MUTATION_KEY = void 0;
var _reactQuery = require("@tanstack/react-query");
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var i18n = _interopRequireWildcard(require("./translations"));
var _api = require("../api");
var _use_find_schedules = require("./use_find_schedules");
var _use_app_toasts = require("../../../../../common/hooks/use_app_toasts");
var _use_kibana_feature_flags = require("../../../use_kibana_feature_flags");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CREATE_ATTACK_DISCOVERY_SCHEDULE_MUTATION_KEY = exports.CREATE_ATTACK_DISCOVERY_SCHEDULE_MUTATION_KEY = ['POST', _elasticAssistantCommon.ATTACK_DISCOVERY_SCHEDULES];
const useCreateAttackDiscoverySchedule = () => {
  const {
    addError,
    addSuccess
  } = (0, _use_app_toasts.useAppToasts)();
  const {
    attackDiscoveryPublicApiEnabled
  } = (0, _use_kibana_feature_flags.useKibanaFeatureFlags)();
  const invalidateFindAttackDiscoverySchedule = (0, _use_find_schedules.useInvalidateFindAttackDiscoverySchedule)();
  return (0, _reactQuery.useMutation)(({
    scheduleToCreate
  }) => (0, _api.createAttackDiscoverySchedule)({
    attackDiscoveryPublicApiEnabled,
    body: scheduleToCreate
  }), {
    mutationKey: CREATE_ATTACK_DISCOVERY_SCHEDULE_MUTATION_KEY,
    onSuccess: () => {
      invalidateFindAttackDiscoverySchedule();
      addSuccess(i18n.CREATE_ATTACK_DISCOVERY_SCHEDULES_SUCCESS());
    },
    onError: error => {
      addError(error, {
        title: i18n.CREATE_ATTACK_DISCOVERY_SCHEDULES_FAILURE()
      });
    }
  });
};
exports.useCreateAttackDiscoverySchedule = useCreateAttackDiscoverySchedule;