"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatusFilter = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var i18n = _interopRequireWildcard(require("../translations"));
var _use_find_attack_discoveries = require("../../../../use_find_attack_discoveries");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/attack_discovery/pages/results/history/search_and_filter/status_filter/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StatusFilterComponent = ({
  isLoading = false,
  setStatusItems,
  statusItems
}) => {
  const invalidateFindAttackDiscoveries = (0, _use_find_attack_discoveries.useInvalidateFindAttackDiscoveries)();
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react2.useState)(false);
  const onFilterButtonClick = (0, _react2.useCallback)(() => {
    setIsPopoverOpen(isOpen => !isOpen);
  }, []);
  const closePopover = (0, _react2.useCallback)(() => {
    setIsPopoverOpen(false);
  }, []);
  const filterGroupPopoverId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'statusFilterGroupPopover'
  });
  const button = (0, _react2.useMemo)(() => /*#__PURE__*/_react2.default.createElement(_eui.EuiFilterButton, {
    badgeColor: "subdued",
    "data-test-subj": "statusFilterButton",
    disabled: isLoading,
    iconType: "arrowDown",
    isSelected: isPopoverOpen,
    onClick: onFilterButtonClick,
    hasActiveFilters: !!statusItems.find(item => item.checked === 'on'),
    numActiveFilters: statusItems.filter(item => item.checked === 'on').length,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 7
    }
  }, i18n.STATUS), [isLoading, isPopoverOpen, onFilterButtonClick, statusItems]);
  const onSelectableChange = (0, _react2.useCallback)(newOptions => {
    setStatusItems(newOptions);
    invalidateFindAttackDiscoveries();
  }, [invalidateFindAttackDiscoveries, setStatusItems]);
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFilterGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiPopover, {
    button: button,
    closePopover: closePopover,
    "data-test-subj": "statusFilterPopover",
    id: filterGroupPopoverId,
    isOpen: isPopoverOpen,
    panelPaddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiSelectable, {
    "aria-label": i18n.STATUS,
    "data-test-subj": "statusFilterSelectable",
    onChange: onSelectableChange,
    options: statusItems,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 9
    }
  }, list => /*#__PURE__*/_react2.default.createElement("div", {
    css: (0, _react.css)`
                width: 200px;
              `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 13
    }
  }, list))));
};
const StatusFilter = exports.StatusFilter = /*#__PURE__*/_react2.default.memo(StatusFilterComponent);